/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.List;
import java.util.ListIterator;
import org.jboss.weld.bootstrap.enablement.Item;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ListView;

abstract class EnablementListView
extends ListView<Item, Class<?>> {
    private static final int DEFAULT_PRIORITY = 2500;

    EnablementListView() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Class<?> element) {
        List list;
        Preconditions.checkNotNull(element);
        List list2 = list = this.getDelegate();
        synchronized (list2) {
            return list.add(this.createSource(element, list.isEmpty() ? null : (Item)list.get(list.size() - 1), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> set(int index, Class<?> element) {
        List list;
        Preconditions.checkNotNull(element);
        List list2 = list = this.getDelegate();
        synchronized (list2) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.toView(this.getDelegate().set(index, this.createSource(element, ((Item)list.get(index)).getPriority())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Class<?> element) {
        List list;
        Preconditions.checkNotNull(element);
        List list2 = list = this.getDelegate();
        synchronized (list2) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException();
            }
            Item previous = index > 0 ? (Item)list.get(index - 1) : null;
            Item next = index <= list.size() - 1 ? (Item)list.get(index) : null;
            list.add(index, this.createSource(element, previous, next));
        }
    }

    @Override
    protected Class<?> toView(Item source) {
        return source.getJavaClass();
    }

    @Override
    protected Item createSource(Class<?> view) {
        throw new UnsupportedOperationException();
    }

    private Item createSource(Class<?> view, Item previous, Item next) {
        return this.createSource(view, this.getPriority(previous, next));
    }

    private Item createSource(Class<?> view, int priority) {
        return new Item(view, priority);
    }

    private int getPriority(Item previous, Item next) {
        int priority;
        if (previous == null && next == null) {
            priority = 2500;
        } else if (previous != null && next != null) {
            int gap = next.getPriority() - previous.getPriority();
            if (gap == 0) {
                priority = next.getPriority();
            } else if (gap == 1) {
                for (Item item : this.getDelegate()) {
                    item.scalePriority();
                }
                priority = this.getPriority(previous, next);
            } else {
                priority = gap / 2 + previous.getPriority();
            }
        } else {
            priority = previous != null ? previous.getPriority() + 10 : next.getPriority() - 10;
        }
        return priority;
    }

    @Override
    public ListIterator<Class<?>> listIterator() {
        return new EnablementListViewIterator(this.getDelegate().listIterator());
    }

    @Override
    public ListIterator<Class<?>> listIterator(int index) {
        return new EnablementListViewIterator(this.getDelegate().listIterator(index));
    }

    class EnablementListViewIterator
    extends ListView.ListViewIterator {
        private Item lastItem;

        public EnablementListViewIterator(ListIterator<Item> delegate) {
            super(delegate);
        }

        @Override
        public Class<?> next() {
            this.lastItem = (Item)this.delegate.next();
            return EnablementListView.this.toView(this.lastItem);
        }

        @Override
        public Class<?> previous() {
            this.lastItem = (Item)this.delegate.previous();
            return EnablementListView.this.toView(this.lastItem);
        }

        @Override
        public void set(Class<?> e) {
            this.delegate.set(EnablementListView.this.createSource(e, this.lastItem.getPriority()));
        }

        @Override
        public void add(Class<?> e) {
            Item previous = this.hasPrevious() ? (Item)EnablementListView.this.getDelegate().get(this.previousIndex()) : null;
            Item next = this.hasNext() ? (Item)EnablementListView.this.getDelegate().get(this.nextIndex()) : null;
            this.delegate.add(EnablementListView.this.createSource(e, previous, next));
        }
    }
}

