/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.weld.util.collections.Iterators;

public final class Iterables {
    private Iterables() {
    }

    public static <T> boolean addAll(Collection<T> target, Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return target.addAll((Collection)iterable);
        }
        return Iterators.addAll(target, iterable.iterator());
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        return () -> Iterators.concat(Iterables.iterators(iterables));
    }

    public static <T> Iterator<Iterator<? extends T>> iterators(Iterable<? extends Iterable<? extends T>> iterables) {
        final Iterator<? extends Iterable<? extends T>> iterator = iterables.iterator();
        return new Iterator<Iterator<? extends T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Iterator<? extends T> next() {
                return ((Iterable)iterator.next()).iterator();
            }
        };
    }
}

