/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.metadata;

import java.util.Iterator;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.weld.integration.deployer.metadata.WeldAwareMetadataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldEjbInterceptorMetadataDeployer
extends WeldAwareMetadataDeployer<JBossMetaData> {
    public static final String CONTEXT_INTERCEPTOR_CLASS_NAME = "org.jboss.weld.integration.ejb.SessionBeanInterceptor";
    public static final String BINDINGS_INTERCEPTOR_CLASS_NAME = "org.jboss.weld.integration.ejb.interceptor.Jsr299BindingsInterceptor";
    private InterceptorMetaData SBI;
    private InterceptorMetaData BIND;
    private InterceptorBindingMetaData CONTEXT_IBMD;
    private InterceptorBindingMetaData BINDINGS_IMDB;

    public WeldEjbInterceptorMetadataDeployer() {
        super(JBossMetaData.class, true);
        this.addInput("WELD_FILES");
        this.addInput("merged." + JBossMetaData.class.getName());
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.SBI = new InterceptorMetaData();
        this.SBI.setInterceptorClass(CONTEXT_INTERCEPTOR_CLASS_NAME);
        this.BIND = new InterceptorMetaData();
        this.BIND.setInterceptorClass(BINDINGS_INTERCEPTOR_CLASS_NAME);
        this.CONTEXT_IBMD = this.createInterceptorBindingMetadata(CONTEXT_INTERCEPTOR_CLASS_NAME);
        this.BINDINGS_IMDB = this.createInterceptorBindingMetadata(BINDINGS_INTERCEPTOR_CLASS_NAME);
    }

    private InterceptorBindingMetaData createInterceptorBindingMetadata(String interceptorClassName) {
        InterceptorBindingMetaData ibmd = new InterceptorBindingMetaData();
        InterceptorClassesMetaData interceptorClasses = new InterceptorClassesMetaData();
        interceptorClasses.add((Object)interceptorClassName);
        ibmd.setInterceptorClasses(interceptorClasses);
        ibmd.setEjbName("*");
        return ibmd;
    }

    @Override
    protected void internalDeploy(VFSDeploymentUnit unit, JBossMetaData jbmd, VirtualFile wbXml) throws DeploymentException {
        InterceptorBindingsMetaData interceptorBindings;
        InterceptorsMetaData interceptors = jbmd.getInterceptors();
        if (interceptors == null) {
            InterceptorsMetaData imd = new InterceptorsMetaData();
            imd.add((MappableMetaData)this.SBI);
            imd.add((MappableMetaData)this.BIND);
            EjbJar30MetaData ejmd = new EjbJar30MetaData();
            ejmd.setInterceptors(imd);
            jbmd.merge(null, (EjbJarMetaData)ejmd);
        } else {
            interceptors.add((MappableMetaData)this.SBI);
            interceptors.add((MappableMetaData)this.BIND);
        }
        JBossAssemblyDescriptorMetaData assemblyDescriptor = jbmd.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = new JBossAssemblyDescriptorMetaData();
            jbmd.setAssemblyDescriptor(assemblyDescriptor);
        }
        if ((interceptorBindings = assemblyDescriptor.getInterceptorBindings()) == null) {
            interceptorBindings = new InterceptorBindingsMetaData();
            assemblyDescriptor.setInterceptorBindings(interceptorBindings);
        }
        interceptorBindings.add(0, (Object)this.CONTEXT_IBMD);
        interceptorBindings.add((Object)this.BINDINGS_IMDB);
        for (InterceptorBindingMetaData interceptorBinding : interceptorBindings) {
            Object lastInterceptorClassName;
            if (interceptorBinding.getInterceptorOrder() == null || interceptorBinding.getInterceptorOrder().isEmpty()) continue;
            if (!CONTEXT_INTERCEPTOR_CLASS_NAME.equals(interceptorBinding.getInterceptorOrder().iterator().next())) {
                this.log.warn((Object)("The Web Beans SessionnBeanInterceptor is not the inner most EJB interceptor in this deployment. JSR299 injection may not work correctly. Specify org.jboss.weld.integration.ejb.SessionBeanInterceptor as the first interceptor in the interceptor ordering for " + interceptorBinding.getEjbName()));
            }
            Iterator iterator = interceptorBinding.getInterceptorOrder().iterator();
            do {
                lastInterceptorClassName = iterator.next();
            } while (iterator.hasNext());
            if (BINDINGS_INTERCEPTOR_CLASS_NAME.equals(lastInterceptorClassName)) continue;
            this.log.warn((Object)("The Web Beans Jsr299BindingsInterceptor is not the outer most EJB interceptor in this deployment. JSR299 requires that @InterceptorBinding-bound interceptors should execute after @Interceptors-registered interceptors. Specify org.jboss.weld.integration.ejb.interceptor.Jsr299BindingsInterceptor as the last interceptor in the interceptor ordering for " + interceptorBinding.getEjbName()));
        }
    }
}

