/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.examples.numberguess;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.weld.examples.numberguess.MaxNumber;
import org.jboss.weld.examples.numberguess.Random;

@Named
@SessionScoped
public class Game
implements Serializable {
    private static final long serialVersionUID = 991300443278089016L;
    private static final int DEFAULT_REMAINING_GUESSES = 10;
    private int number;
    private int guess;
    private int smallest;
    @Inject
    @MaxNumber
    private int maxNumber;
    private int biggest;
    private int remainingGuesses;
    @Inject
    @Random
    Instance<Integer> randomNumber;

    public int getNumber() {
        return this.number;
    }

    public int getGuess() {
        return this.guess;
    }

    public void setGuess(int guess) {
        this.guess = guess;
    }

    public int getSmallest() {
        return this.smallest;
    }

    public int getBiggest() {
        return this.biggest;
    }

    public int getRemainingGuesses() {
        return this.remainingGuesses;
    }

    public void check() {
        if (this.guess > this.number) {
            this.biggest = this.guess - 1;
        } else if (this.guess < this.number) {
            this.smallest = this.guess + 1;
        } else if (this.guess == this.number) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Correct!"));
        }
        --this.remainingGuesses;
    }

    @PostConstruct
    public void reset() {
        this.smallest = 0;
        this.guess = 0;
        this.remainingGuesses = 10;
        this.biggest = this.maxNumber;
        this.number = (Integer)this.randomNumber.get();
    }

    public void validateNumberRange(FacesContext context, UIComponent toValidate, Object value) {
        if (this.remainingGuesses <= 0) {
            FacesMessage message = new FacesMessage("No guesses left!");
            context.addMessage(toValidate.getClientId(context), message);
            ((UIInput)toValidate).setValid(false);
            return;
        }
        int input = (Integer)value;
        if (input < this.smallest || input > this.biggest) {
            ((UIInput)toValidate).setValid(false);
            FacesMessage message = new FacesMessage("Invalid guess");
            context.addMessage(toValidate.getClientId(context), message);
        }
    }
}

