/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.lookup.typesafe;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.AmbiguousDependencyException;
import javax.inject.AnnotationLiteral;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.TypeLiteral;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.CurrentBinding;
import org.jboss.webbeans.tck.unit.lookup.typesafe.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.lookup.typesafe.AnotherDeploymentTypeLiteral;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Cod;
import org.jboss.webbeans.tck.unit.lookup.typesafe.FinalTuna_Broken;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ParameterizedBean_Broken;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Salmon;
import org.jboss.webbeans.tck.unit.lookup.typesafe.ScottishFish;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Sole;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Tuna;
import org.jboss.webbeans.tck.unit.lookup.typesafe.Whitefish;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiationByTypeTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"resolution", "beanLifecycle"})
    @SpecAssertion(section={"5.8"})
    public void testCurrentBindingTypeAssumed() {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        assert (this.manager.getInstanceByType(Tuna.class, new Annotation[0]) != null);
    }

    @Test(groups={"resolution"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"5.8"})
    public void testParameterizedTypeWithWildcardParameter() {
        this.manager.getInstanceByType(new TypeLiteral<ParameterizedBean_Broken<?>>(){}, new Annotation[0]);
    }

    @Test(groups={"resolution"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"5.8"})
    public <T> void testParameterizedTypeWithTypeParameter() {
        this.manager.getInstanceByType(new TypeLiteral<ParameterizedBean_Broken<T>>(){}, new Annotation[0]);
    }

    @Test(groups={"resolution"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"5.8"})
    public void testDuplicateBindingTypesUsed() {
        this.manager.getInstanceByType(Tuna.class, new Annotation[]{new CurrentBinding(), new CurrentBinding()});
    }

    @Test(groups={"resolution"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"5.8"})
    public void testNonBindingTypeUsed() {
        this.manager.getInstanceByType(Tuna.class, new Annotation[]{new AnotherDeploymentTypeLiteral()});
    }

    @Test(expectedExceptions={AmbiguousDependencyException.class})
    @SpecAssertion(section={"5.8"})
    public void testAmbiguousDependencies() throws Exception {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        this.manager.getInstanceByType(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}});
    }

    @Test(expectedExceptions={UnsatisfiedDependencyException.class})
    @SpecAssertion(section={"5.8"})
    public void testUnsatisfiedDependencies() throws Exception {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        this.manager.getInstanceByType(Tuna.class, new Annotation[]{new CurrentBinding()});
    }

    @Test(expectedExceptions={UnproxyableDependencyException.class})
    @SpecAssertion(section={"5.8"})
    public void testUnproxyableDependencies() throws Exception {
        this.deployBeans(FinalTuna_Broken.class);
        this.manager.getInstanceByType(FinalTuna_Broken.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}});
    }
}

