/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.lookup.clientProxy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.DefinitionException;
import javax.inject.UnproxyableDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.WebBeansTCKImpl;
import org.jboss.webbeans.tck.unit.lookup.clientProxy.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.lookup.clientProxy.FinalTuna_Broken;
import org.jboss.webbeans.tck.unit.lookup.clientProxy.Fox;
import org.jboss.webbeans.tck.unit.lookup.clientProxy.Tuna;
import org.jboss.webbeans.tck.unit.lookup.clientProxy.TunedTuna;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"configuration().getBeans()"})
    @SpecAssertion(section={"5.4"})
    public void testClientProxyUsedForNormalScope() {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        Tuna tuna = (Tuna)this.manager.getInstance(tunaBean);
        assert (WebBeansTCKImpl.configuration().getBeans().isProxy((Object)tuna));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"configuration().getBeans()"})
    @SpecAssertion(section={"5.4"})
    public void testClientProxyNotUsedForPseudoScope() {
        Bean<Fox> foxBean = this.createSimpleBean(Fox.class);
        try {
            ClientProxyTest.activateDependentContext();
            Fox fox = (Fox)this.manager.getInstance(foxBean);
            assert (!WebBeansTCKImpl.configuration().getBeans().isProxy((Object)fox));
        }
        finally {
            ClientProxyTest.deactivateDependentContext();
        }
    }

    @Test(groups={"configuration().getBeans()"})
    @SpecAssertion(section={"5.4"})
    public void testSimpleWebBeanClientProxyIsSerializable() throws IOException, ClassNotFoundException {
        Bean<TunedTuna> tunaBean = this.createSimpleBean(TunedTuna.class);
        this.manager.addBean(tunaBean);
        TunedTuna tuna = (TunedTuna)this.manager.getInstance(tunaBean);
        assert (WebBeansTCKImpl.configuration().getBeans().isProxy((Object)tuna));
        byte[] bytes = this.serialize(tuna);
        tuna = (TunedTuna)this.deserialize(bytes);
        assert (WebBeansTCKImpl.configuration().getBeans().isProxy((Object)tuna));
        assert (tuna.getState().equals("tuned"));
    }

    @Test(groups={"configuration().getBeans()"}, expectedExceptions={UnproxyableDependencyException.class})
    @SpecAssertion(section={"5.4.1"})
    public void testInjectionPointWithUnproxyableTypeWhichResolvesToNormalScopedWebBean() {
        Bean<FinalTuna_Broken> tunaBean = this.createSimpleBean(FinalTuna_Broken.class);
        this.manager.addBean(tunaBean);
        FinalTuna_Broken tuna = (FinalTuna_Broken)this.manager.getInstanceByType(FinalTuna_Broken.class, new Annotation[0]);
        assert (false);
    }

    @Test(groups={"configuration().getBeans()"})
    @SpecAssertion(section={"5.4.2"})
    public void testClientProxyInvocation() {
        Bean<TunedTuna> tunaBean = this.createSimpleBean(TunedTuna.class);
        this.manager.addBean(tunaBean);
        TunedTuna tuna = (TunedTuna)this.manager.getInstance(tunaBean);
        assert (WebBeansTCKImpl.configuration().getBeans().isProxy((Object)tuna));
        assert (tuna.getState().equals("tuned"));
    }

    @Test(groups={"configuration().getBeans()"}, expectedExceptions={DefinitionException.class})
    public void testGettingUnknownBeanFails() {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        Tuna tuna = (Tuna)this.manager.getInstance(tunaBean);
        assert (false);
    }
}

