/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.lookup.byname;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.AmbiguousDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.lookup.byname.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.lookup.byname.Cod;
import org.jboss.webbeans.tck.unit.lookup.byname.Haddock;
import org.jboss.webbeans.tck.unit.lookup.byname.Plaice;
import org.jboss.webbeans.tck.unit.lookup.byname.Salmon;
import org.jboss.webbeans.tck.unit.lookup.byname.SeaBass;
import org.jboss.webbeans.tck.unit.lookup.byname.Sole;
import org.jboss.webbeans.tck.unit.lookup.byname.Tuna;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionByNameTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"stub", "el"})
    @SpecAssertion(section={"5.11"})
    public void testELResolver() {
        assert (this.manager.getInstanceByName("nonexistant") == null);
        try {
            ResolutionByNameTest.activateDependentContext();
            Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
            this.manager.addBean(salmonBean);
            assert (this.manager.getInstanceByName("salmon") instanceof Salmon);
        }
        finally {
            ResolutionByNameTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={AmbiguousDependencyException.class})
    @SpecAssertion(section={"5.11"})
    public void testDuplicateNamedBeans() {
        try {
            ResolutionByNameTest.activateDependentContext();
            Bean<Cod> codBean = this.createSimpleBean(Cod.class);
            Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
            this.manager.addBean(codBean);
            this.manager.addBean(soleBean);
            assert (this.manager.resolveByName("whitefish").size() == 2);
            this.manager.getInstanceByName("whitefish");
        }
        finally {
            ResolutionByNameTest.deactivateDependentContext();
        }
    }

    @Test
    @SpecAssertion(section={"5.11"})
    public void testNamedBasedResolution() {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        Bean<SeaBass> seaBassBean = this.createSimpleBean(SeaBass.class);
        Bean<Haddock> haddockBean = this.createSimpleBean(Haddock.class);
        Bean<Plaice> plaiceBean = this.createSimpleBean(Plaice.class);
        this.manager.addBean(tunaBean);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        this.manager.addBean(haddockBean);
        this.manager.addBean(seaBassBean);
        assert (this.manager.resolveByName("salmon").size() == 1);
        assert (this.manager.resolveByName("salmon").contains(salmonBean));
        assert (this.manager.resolveByName("whitefish").size() == 2);
        assert (this.manager.resolveByName("whitefish").contains(codBean));
        assert (this.manager.resolveByName("whitefish").contains(soleBean));
        this.manager.addBean(plaiceBean);
        assert (this.manager.resolveByName("whitefish").size() == 1);
        assert (this.manager.resolveByName("whitefish").contains(plaiceBean));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.11"})
    public void testNoWebBeansFound() throws Exception {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        assert (this.manager.resolveByName("foo").size() == 0);
    }

    @Test(groups={"stub"})
    @SpecAssertion(section={"5.11"})
    public void testOnlyHighestPrecedenceResolved() {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Plaice> plaiceBean = this.createSimpleBean(Plaice.class);
        this.manager.addBean(codBean);
        this.manager.addBean(plaiceBean);
        assert (this.manager.resolveByName("whitefish").size() == 1);
        assert (!this.manager.resolveByName("whitefish").contains(codBean));
        assert (this.manager.resolveByName("whitefish").contains(plaiceBean));
    }
}

