/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.InconsistentSpecializationException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.Reflections;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.Bookshop_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.ClothesShop_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.Expensive;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.FurnitureShop_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.HighSchool_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.JewelryShop;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.Necklace;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.PictureShop_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.Product;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.ShoeShop_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.Shop;
import org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method.Sparkly;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethodSpecializationTest
extends AbstractTest {
    private static Annotation EXPENSIVE_LITERAL = new AnnotationLiteral<Expensive>(){};

    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        ArrayList<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
        deploymentTypes.addAll(this.getStandardDeploymentTypes());
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test
    @SpecAssertion(section={"4.3.1", "3.4.5"})
    public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean() {
        this.deployBeans(JewelryShop.class);
        assert (this.manager.resolveByType(Product.class, new Annotation[]{EXPENSIVE_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Product.class, new Annotation[]{EXPENSIVE_LITERAL}).iterator().next()).getBindings().size() == 2);
        assert (Reflections.annotationSetMatches(((Bean)this.manager.resolveByType(Product.class, new Annotation[]{EXPENSIVE_LITERAL}).iterator().next()).getBindings(), Expensive.class, Sparkly.class));
    }

    @Test
    @SpecAssertion(section={"4.3.1", "3.4.5"})
    public void testSpecializingBeanHasNameOfSpecializedBean() {
        this.deployBeans(JewelryShop.class);
        assert (this.manager.resolveByType(Product.class, new Annotation[]{new AnnotationLiteral<Sparkly>(){}}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Product.class, new Annotation[]{new AnnotationLiteral<Sparkly>(){}}).iterator().next()).getName().equals("expensiveGift"));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"4.3.1"})
    public void testSpecializingAndSpecializedBeanHasName() {
        this.deployBeans(HighSchool_Broken.class);
    }

    @Test
    @SpecAssertion(section={"4.3.1", "3.4.5"})
    public void testSpecializedBeanNotInstantiated() throws Exception {
        this.deployBeans(JewelryShop.class, Shop.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Product product = (Product)ProducerMethodSpecializationTest.this.manager.getInstanceByType(Product.class, new Annotation[]{EXPENSIVE_LITERAL});
                assert (product instanceof Necklace);
            }
        }.run();
    }

    @Test(expectedExceptions={InconsistentSpecializationException.class})
    @SpecAssertion(section={"4.3.1"})
    public void testSpecializingBeanDoesNotHaveHigherPrecedenceThanSpecializedBean() {
        this.deployBeans(ClothesShop_Broken.class);
    }

    @Test(expectedExceptions={InconsistentSpecializationException.class})
    @SpecAssertion(section={"4.3.1"})
    public void testTwoBeansSpecializeTheSameBean() {
        this.deployBeans(PictureShop_Broken.class, Bookshop_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4.5"})
    public void testSpecializedStaticMethod() {
        this.deployBeans(FurnitureShop_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4.5"})
    public void testSpecializedMethodDoesNotOverrideAnotherProducerMethod() {
        this.deployBeans(FurnitureShop_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.4.5"})
    public void testSpecializedMethodIndirectlyOverridesAnotherProducerMethod() {
        this.deployBeans(ShoeShop_Broken.class);
    }
}

