/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.inheritance.realization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.context.RequestScoped;
import javax.inject.AnnotationLiteral;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.Reflections;
import org.jboss.webbeans.tck.unit.inheritance.realization.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.inheritance.realization.Cow;
import org.jboss.webbeans.tck.unit.inheritance.realization.Dog;
import org.jboss.webbeans.tck.unit.inheritance.realization.Dung;
import org.jboss.webbeans.tck.unit.inheritance.realization.FarmAnimalDeploymentType;
import org.jboss.webbeans.tck.unit.inheritance.realization.FarmHouse;
import org.jboss.webbeans.tck.unit.inheritance.realization.Horse;
import org.jboss.webbeans.tck.unit.inheritance.realization.LabradorKennel;
import org.jboss.webbeans.tck.unit.inheritance.realization.Smelly;
import org.jboss.webbeans.tck.unit.inheritance.realization.Stable;
import org.jboss.webbeans.tck.unit.inheritance.realization.Tame;
import org.jboss.webbeans.tck.unit.inheritance.realization.TameCow;
import org.jboss.webbeans.tck.unit.inheritance.realization.TameHorse;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizationTest
extends AbstractTest {
    private static Annotation SMELLY_LITERAL = new AnnotationLiteral<Smelly>(){};

    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        ArrayList<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
        deploymentTypes.addAll(this.getStandardDeploymentTypes());
        deploymentTypes.add(AnotherDeploymentType.class);
        deploymentTypes.add(FarmAnimalDeploymentType.class);
        return deploymentTypes;
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerMethodHasSameScope() {
        this.deployBeans(Cow.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerMethodHasDeploymentTypeOfRealizingClass() {
        this.deployBeans(Cow.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getDeploymentType().equals(AnotherDeploymentType.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerMethodHasSameBindings() {
        this.deployBeans(Cow.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings().iterator().next()).annotationType().equals(Smelly.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerMethodHasBindingsOfMethodAndRealizingType() {
        this.deployBeans(TameCow.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings().size() == 2);
        assert (Reflections.annotationSetMatches(((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings(), Smelly.class, Tame.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerMethodHasSameStereotypes() {
        this.deployBeans(LabradorKennel.class);
        assert (this.manager.resolveByType(Dog.class, new Annotation[0]).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dog.class, new Annotation[0]).iterator().next()).getScopeType().equals(RequestScoped.class));
    }

    @Test(groups={"stub"})
    @SpecAssertion(section={"4.1"})
    public void testRealizedBeanWithProducerMethodHasSameInterceptorBindings() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerFieldHasSameScope() {
        this.deployBeans(Horse.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerFieldHasDeploymentTypeOfRealizingClass() {
        this.deployBeans(Horse.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getDeploymentType().equals(AnotherDeploymentType.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerFieldHasSameBindings() {
        this.deployBeans(Horse.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings().iterator().next()).annotationType().equals(Smelly.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerFieldHasBindingsOfMethodAndRealizingType() {
        this.deployBeans(TameHorse.class);
        assert (this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings().size() == 2);
        assert (Reflections.annotationSetMatches(((Bean)this.manager.resolveByType(Dung.class, new Annotation[]{SMELLY_LITERAL}).iterator().next()).getBindings(), Smelly.class, Tame.class));
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerFieldHasSameStereotypes() {
        this.deployBeans(Stable.class);
        assert (this.manager.resolveByType(Horse.class, new Annotation[0]).size() == 1);
        assert (((Bean)this.manager.resolveByType(Horse.class, new Annotation[0]).iterator().next()).getScopeType().equals(RequestScoped.class));
    }

    @Test(groups={"stub"})
    @SpecAssertion(section={"4.4"})
    public void testRealizedBeanWithProducerFieldHasSameInterceptorBindings() {
        assert (false);
    }

    @Test(groups={"stub"})
    @SpecAssertion(section={"4.4"})
    public void testDisposalMethodInherited() {
        assert (false);
    }

    @Test(groups={"stub"})
    @SpecAssertion(section={"4.4"})
    public void testRealizedDisposalMethodHasBindingsOfMethodAndRealizingType() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"4.4"})
    public void testObserverMethodInheritedAndHasSameBindings() {
        this.deployBeans(FarmHouse.class);
        assert (this.manager.resolveObservers((Object)new Cow(), new Annotation[]{new AnnotationLiteral<Tame>(){}}).size() == 1);
        assert (this.manager.resolveObservers((Object)new Cow(), new Annotation[]{SMELLY_LITERAL}).size() == 0);
    }
}

