/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.simple;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.implementation.simple.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.implementation.simple.Cow_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.Donkey;
import org.jboss.webbeans.tck.unit.implementation.simple.Duck;
import org.jboss.webbeans.tck.unit.implementation.simple.Goose_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.Leopard_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.MockEnterpriseBean;
import org.jboss.webbeans.tck.unit.implementation.simple.MockFilter;
import org.jboss.webbeans.tck.unit.implementation.simple.MockHttpSessionListener;
import org.jboss.webbeans.tck.unit.implementation.simple.MockServlet;
import org.jboss.webbeans.tck.unit.implementation.simple.MockServletContextListener;
import org.jboss.webbeans.tck.unit.implementation.simple.MockServletRequestListener;
import org.jboss.webbeans.tck.unit.implementation.simple.MockUIComponent;
import org.jboss.webbeans.tck.unit.implementation.simple.Order;
import org.jboss.webbeans.tck.unit.implementation.simple.OuterBean_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.ParameterizedBean_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.Sheep;
import org.jboss.webbeans.tck.unit.implementation.simple.Tiger;
import org.jboss.webbeans.tck.unit.implementation.simple.Turkey;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanDefinitionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2"})
    public void testAbstractClassDeclaredInJavaIsNotAllowed() {
        this.createSimpleBean(Cow_Broken.class);
    }

    @Test(groups={"innerClass"})
    @SpecAssertion(section={"3.2"})
    public void testStaticInnerClassDeclaredInJavaAllowed() {
        this.createSimpleBean(OuterBean_Broken.StaticInnerBean_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"innerClass"})
    @SpecAssertion(section={"3.2"})
    public void testNonStaticInnerClassDeclaredInJavaNotAllowed() {
        this.createSimpleBean(OuterBean_Broken.InnerBean_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2"})
    public void testParameterizedClassDeclaredInJavaIsNotAllowed() {
        this.createSimpleBean(ParameterizedBean_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "interceptors", "decorators"})
    @SpecAssertion(section={"3.2"})
    public void testClassCannotBeInterceptorAndDecorator() {
    }

    @Test(groups={"stub"})
    public void testEntitiesNotDiscoveredAsSimpleBeans() {
        assert (false);
    }

    @Test
    public void testClassesImplementingServletInterfacesNotDiscoveredAsSimpleBeans() {
        this.deployBeans(MockFilter.class, MockHttpSessionListener.class, MockServlet.class, MockServletContextListener.class, MockServletRequestListener.class);
        assert (this.manager.resolveByType(MockFilter.class, new Annotation[0]).size() == 0);
        assert (this.manager.resolveByType(MockHttpSessionListener.class, new Annotation[0]).size() == 0);
        assert (this.manager.resolveByType(MockServlet.class, new Annotation[0]).size() == 0);
        assert (this.manager.resolveByType(MockServletContextListener.class, new Annotation[0]).size() == 0);
        assert (this.manager.resolveByType(MockServletRequestListener.class, new Annotation[0]).size() == 0);
    }

    @Test
    public void testClassesImplementingEnterpriseBeanInterfaceNotDiscoveredAsSimpleBean() {
        this.deployBeans(MockEnterpriseBean.class);
        assert (this.manager.resolveByType(MockEnterpriseBean.class, new Annotation[0]).size() == 0);
    }

    @Test
    public void testClassExtendingUiComponentNotDiscoveredAsSimpleBean() {
        this.deployBeans(MockUIComponent.class);
        assert (this.manager.resolveByType(MockUIComponent.class, new Annotation[0]).size() == 0);
    }

    @Test(groups={"stub"})
    public void testEjbsNotDiscoveredAsSimpleBean() {
    }

    @Test(groups={"stub", "producerMethod", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testBeanDeclaredInXmlIgnoresProducerMethodDeclaredInJava() {
        assert (false);
    }

    @Test(groups={"stub", "disposalMethod", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testBeanDeclaredInXmlIgnoresDisposalMethodDeclaredInJava() {
        assert (false);
    }

    @Test(groups={"stub", "observerMethod", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testBeanDeclaredInXmlIgnoresObserverMethodDeclaredInJava() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testAbstractClassDeclaredInXmlIsNotAllowed() {
    }

    @Test(groups={"stub", "innerClass", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testStaticInnerClassDeclaredInXmlAllowed() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "innerClass", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testNonStaticInnerClassDeclaredInXmlNotAllowed() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"3.2.4"})
    public void testParameterizedClassDeclaredInXmlIsNotAllowed() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "interceptors"})
    @SpecAssertion(section={"3.2.4"})
    public void testClassHasInterceptorInJavaMustHaveInterceptorInXml() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "interceptors"})
    @SpecAssertion(section={"3.2.4"})
    public void testClassHasDecoratorInJavaMustHaveDecoratorInXml() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"3.2.5.1"})
    public void testInitializerAnnotatedConstructor() throws Exception {
        this.deployBeans(Sheep.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                SimpleBeanDefinitionTest.this.manager.getInstanceByType(Sheep.class, new Annotation[0]);
                assert (Sheep.constructedCorrectly);
            }
        }.run();
    }

    @Test
    @SpecAssertion(section={"3.2.5.1"})
    public void testImplicitConstructorUsed() {
        Bean<Order> order = this.createSimpleBean(Order.class);
    }

    @Test
    @SpecAssertion(section={"3.2.6.1"})
    public void testEmptyConstructorUsed() {
        this.createSimpleBean(Donkey.class).create(new MockCreationalContext());
        assert (Donkey.constructedCorrectly);
    }

    @Test
    @SpecAssertion(section={"3.2.6.1"})
    public void testInitializerAnnotatedConstructorUsedOverEmptyConstuctor() throws Exception {
        this.deployBeans(Turkey.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                SimpleBeanDefinitionTest.this.manager.getInstanceByType(Turkey.class, new Annotation[0]);
                assert (Turkey.constructedCorrectly);
            }
        }.run();
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.6.1"})
    public void testTooManyInitializerAnnotatedConstructor() {
        this.createSimpleBean(Goose_Broken.class);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "disposalMethod"})
    @SpecAssertion(section={"3.2.6.1"})
    public void testConstructorHasDisposesParameter() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "observerMethod"})
    @SpecAssertion(section={"3.2.6.1"})
    public void testConstructorHasObservesParameter() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"3.2.6.2"})
    public void testImplicitConstructorDeclaredInXmlUsed() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"3.2.6.2"})
    public void testEmptyConstructorDeclaredInXmlUsed() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class}, groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"3.2.6.2"})
    public void testConstructorDeclaredInXmlDoesNotExist() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"3.2.6.2"})
    public void testConstructorDeclaredInXmlIgnoresBindingTypesDeclaredInJava() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"3.2.6.3"})
    public void testBindingTypeAnnotatedConstructor() throws Exception {
        this.deployBeans(Duck.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                SimpleBeanDefinitionTest.this.manager.getInstanceByType(Duck.class, new Annotation[0]);
                assert (Duck.constructedCorrectly);
            }
        }.run();
    }

    @Test
    @SpecAssertion(section={"3.2"})
    public void testDependentScopedBeanCanHavePublicField() throws Exception {
        this.deployBeans(Tiger.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                assert (((Tiger)((SimpleBeanDefinitionTest)SimpleBeanDefinitionTest.this).manager.getInstanceByType(Tiger.class, (Annotation[])new Annotation[0])).name.equals("pete"));
            }
        }.run();
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2"})
    public void testNonDependentScopedBeanCanNotHavePublicField() {
        this.deployBeans(Leopard_Broken.class);
    }
}

