/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.initializer;

import javax.inject.DefinitionException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.implementation.initializer.Capercaillie;
import org.jboss.webbeans.tck.unit.implementation.initializer.Chicken;
import org.jboss.webbeans.tck.unit.implementation.initializer.ChickenHutch;
import org.jboss.webbeans.tck.unit.implementation.initializer.Dottrel;
import org.jboss.webbeans.tck.unit.implementation.initializer.Fox;
import org.jboss.webbeans.tck.unit.implementation.initializer.Grouse;
import org.jboss.webbeans.tck.unit.implementation.initializer.Pheasant;
import org.testng.annotations.Test;

public class InitializerMethodTest
extends AbstractTest {
    @Test(expectedExceptions={DefinitionException.class}, groups={"initializerMethod"})
    @SpecAssertion(section={"3.8"})
    public void testStaticInitializerMethodNotAllowed() {
        this.createSimpleBean(Dottrel.class);
    }

    @Test(groups={"stub", "initializerMethod", "servlet"})
    @SpecAssertion(section={"3.9"})
    public void testInitializerMethodCalledOnServlet() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "ejb3"})
    @SpecAssertion(section={"3.9"})
    public void testInitializerMethodCalledOnEJBSessionBean() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "ejb3"})
    @SpecAssertion(section={"3.9"})
    public void testInitializerMethodCalledOnEJBMDB() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "ejb3", "singletons"})
    @SpecAssertion(section={"3.9"})
    public void testInitializerMethodCalledOnEJBSingleton() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "ejb3"})
    @SpecAssertion(section={"3.9"})
    public void testInitializerMethodNotABusinessMethod() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "interceptors"})
    @SpecAssertion(section={"3.9"})
    public void testMethodInterceptorNotCalledOnInitializerMethod() {
        assert (false);
    }

    @Test(groups={"initializerMethod"})
    @SpecAssertion(section={"3.9", "5.3", "3.9.2", "3.9.3"})
    public void testMultipleInitializerMethodsAreCalled() {
        this.manager.addBean(this.createSimpleBean(Fox.class));
        this.manager.addBean(this.createSimpleBean(Chicken.class));
        Bean<ChickenHutch> chickenHutchBean = this.createSimpleBean(ChickenHutch.class);
        ChickenHutch chickenHutch = (ChickenHutch)chickenHutchBean.create(new MockCreationalContext());
        assert (chickenHutch.fox != null);
        assert (chickenHutch.chicken != null);
    }

    @Test(groups={"initializerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.9.1", "3.4.2"})
    public void testInitializerMethodAnnotatedProduces() {
        this.createSimpleBean(Pheasant.class);
    }

    @Test(groups={"initializerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.9.1"})
    public void testInitializerMethodHasParameterAnnotatedDisposes() {
        this.createSimpleBean(Capercaillie.class);
    }

    @Test(groups={"initializerMethod"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.9.1"})
    public void testInitializerMethodHasParameterAnnotatedObserves() {
        this.createSimpleBean(Grouse.class);
    }

    @Test(groups={"stub", "initializerMethod", "webbeansxml"})
    @SpecAssertion(section={"3.9.2"})
    public void testInitializerMethodDeclaredInXml() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "webbeansxml"})
    @SpecAssertion(section={"3.9.2"})
    public void testInitializerMethodDeclaredInXmlIgnoresBindingAnnotationsInJava() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "webbeansxml"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.9.2"})
    public void testInitializerMethodDeclaredInXmlDoesNotExist() {
        assert (false);
    }

    @Test(groups={"stub", "initializerMethod", "webbeansxml"})
    @SpecAssertion(section={"3.9.2"})
    public void testBeanHasAllInitializerMethodsDeclaredInJavaAndXml() {
        assert (false);
    }
}

