/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.enterprise;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.context.Dependent;
import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.DefinitionException;
import javax.inject.New;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.NewLiteral;
import org.jboss.webbeans.tck.unit.implementation.enterprise.AnnotatedConstructorParameter;
import org.jboss.webbeans.tck.unit.implementation.enterprise.AnnotatedField;
import org.jboss.webbeans.tck.unit.implementation.enterprise.AnnotatedInitializerParameter;
import org.jboss.webbeans.tck.unit.implementation.enterprise.AnnotatedProducerParameter;
import org.jboss.webbeans.tck.unit.implementation.enterprise.Lion;
import org.jboss.webbeans.tck.unit.implementation.enterprise.NewAndOtherBindingType_Broken;
import org.jboss.webbeans.tck.unit.implementation.enterprise.Order;
import org.jboss.webbeans.tck.unit.implementation.enterprise.Tame;
import org.jboss.webbeans.tck.unit.implementation.enterprise.WrappedEnterpriseBean;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NewEnterpriseBeanTest
extends AbstractTest {
    private Bean<WrappedEnterpriseBean> newEnterpriseBean;
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @BeforeMethod
    public void initNewBean() {
        this.deployBeans(WrappedEnterpriseBean.class);
        Set beans = this.manager.resolveByType(WrappedEnterpriseBean.class, new Annotation[]{new NewLiteral()});
        assert (beans.size() == 1);
        this.newEnterpriseBean = (Bean)beans.iterator().next();
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanIsDependentScoped() {
        assert (Dependent.class.equals((Object)this.newEnterpriseBean.getScopeType()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanIsOfStandardDeploymentType() {
        assert (Standard.class.equals((Object)this.newEnterpriseBean.getDeploymentType()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanIsHasOnlyNewBinding() {
        assert (this.newEnterpriseBean.getBindings().size() == 1);
        assert (((Annotation)this.newEnterpriseBean.getBindings().iterator().next()).annotationType().equals(new NewLiteral().annotationType()));
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoWebBeanName() {
        assert (this.newEnterpriseBean.getName() == null);
    }

    @Test(groups={"stub", "new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoStereotypes() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanIsEnterpriseWebBeanIfParameterTypeIsEnterpriseWebBean() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasSameInitializerMethodsAsWrappedBean() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasSameInjectedFieldsAsWrappedBean() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoObservers() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoProducerFields() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoProducerMethods() {
        assert (false);
    }

    @Test(groups={"new", "stub"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoDisposalMethods() {
        assert (false);
    }

    @Test(groups={"stub", "new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasSameInterceptorMethodsAsWrappedBean() {
        assert (false);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewBeanHasNoDecorators() {
        Annotation[] bindingTypes = this.newEnterpriseBean.getBindings().toArray(new Annotation[0]);
        assert (this.manager.resolveDecorators(this.newEnterpriseBean.getTypes(), bindingTypes).isEmpty());
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationMayBeAppliedToField() {
        this.deployBeans(AnnotatedField.class, WrappedEnterpriseBean.class);
        assert (this.manager.resolveByType(WrappedEnterpriseBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationMayBeAppliedToProducerMethodParameter() {
        this.deployBeans(AnnotatedProducerParameter.class, WrappedEnterpriseBean.class);
        assert (this.manager.resolveByType(WrappedEnterpriseBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationMayBeAppliedToInitializerMethodParameter() {
        this.deployBeans(AnnotatedInitializerParameter.class, WrappedEnterpriseBean.class);
        assert (this.manager.resolveByType(WrappedEnterpriseBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationMayBeAppliedToConstructorMethodParameter() {
        this.deployBeans(AnnotatedConstructorParameter.class, WrappedEnterpriseBean.class);
        assert (this.manager.resolveByType(WrappedEnterpriseBean.class, new Annotation[]{new NewLiteral()}).size() == 1);
    }

    @Test(groups={"new"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationCannotAppearInConjunctionWithOtherBindingType() {
        this.deployBeans(NewAndOtherBindingType_Broken.class);
    }

    @Test(groups={"stub", "new"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationCannotBeAppliedToNonWebBeanImplementationClass() {
        assert (false);
    }

    @Test(groups={"stub", "new"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.3.6"})
    public void testNewAnnotationCannotBeExplicitlyDeclared() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"3.2.6"})
    public void testForEachEnterpriseBeanANewBeanExists() {
        this.deployBeans(Order.class, Lion.class);
        assert (this.manager.resolveByType(Order.class, new Annotation[0]).size() == 1);
        assert (((Bean)this.manager.resolveByType(Order.class, new Annotation[0]).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Order.class, new Annotation[0]).iterator().next()).getBindings().iterator().next()).annotationType().equals(Current.class));
        assert (this.manager.resolveByType(Order.class, new Annotation[]{new NewLiteral()}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Order.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Order.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().iterator().next()).annotationType().equals(New.class));
        assert (this.manager.resolveByType(Lion.class, new Annotation[]{TAME_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{TAME_LITERAL}).iterator().next()).getBindings().iterator().next()).annotationType().equals(Tame.class));
        assert (this.manager.resolveByType(Lion.class, new Annotation[]{new NewLiteral()}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().size() == 1);
        assert (((Annotation)((Bean)this.manager.resolveByType(Lion.class, new Annotation[]{new NewLiteral()}).iterator().next()).getBindings().iterator().next()).annotationType().equals(New.class));
    }
}

