/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.definition.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.inject.DefinitionException;
import javax.inject.DeploymentException;
import javax.inject.Production;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.definition.deployment.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.definition.deployment.BeanWithTooManyDeploymentTypes_Broken;
import org.jboss.webbeans.tck.unit.definition.deployment.BorderCollie;
import org.jboss.webbeans.tck.unit.definition.deployment.Gazelle_Broken;
import org.jboss.webbeans.tck.unit.definition.deployment.GoldenLabrador;
import org.jboss.webbeans.tck.unit.definition.deployment.GoldenRetriever;
import org.jboss.webbeans.tck.unit.definition.deployment.HornedAnimalDeploymentType;
import org.jboss.webbeans.tck.unit.definition.deployment.InheritedDeploymentType;
import org.jboss.webbeans.tck.unit.definition.deployment.NotInheritedDeploymentType;
import org.jboss.webbeans.tck.unit.definition.deployment.RedSnapper;
import org.jboss.webbeans.tck.unit.definition.deployment.Reindeer;
import org.jboss.webbeans.tck.unit.definition.deployment.Rhinoceros;
import org.jboss.webbeans.tck.unit.definition.deployment.ShetlandPony;
import org.jboss.webbeans.tck.unit.definition.deployment.SpiderProducer;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentTypeDefinitionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        deploymentTypes.add(HornedAnimalDeploymentType.class);
        deploymentTypes.add(NotInheritedDeploymentType.class);
        return deploymentTypes;
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.5.1"})
    public void testNonBuiltInComponentUsesStandard() {
        this.createSimpleBean(Gazelle_Broken.class);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.5.2"})
    public void testDeploymentTypeHasCorrectTarget() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.5.2"})
    public void testDeploymentTypeHasCorrectRetention() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.5.2"})
    public void testDeploymentTypeDeclaresScopeTypeAnnotation() {
        assert (false);
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.5.3"})
    public void testTooManyDeploymentTypes() {
        this.createSimpleBean(BeanWithTooManyDeploymentTypes_Broken.class);
    }

    @Test
    @SpecAssertion(section={"2.5.3"})
    public void testDeploymentTypeInhertitedFromDeclaringBean() throws Exception {
        Bean<SpiderProducer> bean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(bean);
        Method method = SpiderProducer.class.getMethod("produceBlackWidow", new Class[0]);
        Bean blackWidowSpiderModel = this.createProducerMethodBean(method, bean);
        assert (blackWidowSpiderModel.getDeploymentType().equals(AnotherDeploymentType.class));
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.5.4"})
    public void testXmlDeploymentTypeOverridesJava() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.5.4"})
    public void testXmlRespectsJavaDeploymentType() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.5.5"})
    public void testXmlDefaultDeploymentType() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.5.5"})
    public void testHighestPrecedenceDeploymentTypeFromStereotype() {
        Bean<Rhinoceros> bean = this.createSimpleBean(Rhinoceros.class);
        assert (bean.getDeploymentType().equals(HornedAnimalDeploymentType.class));
    }

    @Test(groups={"beanLifecycle"}, expectedExceptions={UnsatisfiedDependencyException.class})
    @SpecAssertion(section={"2.5.6"})
    public void testBeanWithDisabledDeploymentTypeNotInstantiated() {
        Bean<RedSnapper> bean = this.createSimpleBean(RedSnapper.class);
        this.manager.addBean(bean);
        this.manager.getInstanceByType(RedSnapper.class, new Annotation[0]);
    }

    @Test(groups={"stub", "webbeansxml"}, expectedExceptions={DeploymentException.class})
    @SpecAssertion(section={"2.5.6"})
    public void testMultipleDeployElementsCannotBeDefined() {
    }

    @Test
    @SpecAssertion(section={"2.5.5", "2.7.2", "4.1"})
    public void testWebBeanDeploymentTypeOverridesStereotype() {
        Bean<Reindeer> bean = this.createSimpleBean(Reindeer.class);
        assert (bean.getDeploymentType().equals(Production.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testDeploymentTypeDeclaredInheritedIsInherited() throws Exception {
        assert (this.createSimpleBean(BorderCollie.class).getDeploymentType().equals(AnotherDeploymentType.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testDeploymentTypeNotDeclaredInheritedIsNotInherited() {
        assert (this.createSimpleBean(ShetlandPony.class).getDeploymentType().equals(Production.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeNotMarkedInherited() {
        assert (this.createSimpleBean(GoldenRetriever.class).getDeploymentType().equals(Production.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeMarkedInherited() {
        assert (this.createSimpleBean(GoldenLabrador.class).getDeploymentType().equals(InheritedDeploymentType.class));
    }
}

