/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.definition.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.inject.Current;
import javax.inject.Production;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.CurrentBinding;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.impl.util.Reflections;
import org.jboss.webbeans.tck.unit.definition.binding.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.definition.binding.Barn;
import org.jboss.webbeans.tck.unit.definition.binding.BorderCollie;
import org.jboss.webbeans.tck.unit.definition.binding.Cat;
import org.jboss.webbeans.tck.unit.definition.binding.ClippedBorderCollie;
import org.jboss.webbeans.tck.unit.definition.binding.Cod;
import org.jboss.webbeans.tck.unit.definition.binding.DefangedTarantula;
import org.jboss.webbeans.tck.unit.definition.binding.Hairy;
import org.jboss.webbeans.tck.unit.definition.binding.Order;
import org.jboss.webbeans.tck.unit.definition.binding.ShetlandPony;
import org.jboss.webbeans.tck.unit.definition.binding.Spider;
import org.jboss.webbeans.tck.unit.definition.binding.SpiderProducer;
import org.jboss.webbeans.tck.unit.definition.binding.Synchronous;
import org.jboss.webbeans.tck.unit.definition.binding.Tarantula;
import org.jboss.webbeans.tck.unit.definition.binding.Tuna;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingDefinitionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test
    @SpecAssertion(section={"2.3.3", "2.3.1"})
    public void testDefaultBindingDeclaredInJava() {
        Bean<Order> order = this.createSimpleBean(Order.class);
        assert (order.getBindings().size() == 1);
        ((Annotation)order.getBindings().iterator().next()).annotationType().equals(Production.class);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.3.2"})
    public void testBindingHasCorrectTarget() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.3.2"})
    public void testBindingHasCorrectRetention() {
        assert (false);
    }

    @Test(groups={"stub", "annotationDefinition"})
    @SpecAssertion(section={"2.3.2"})
    public void testBindingDeclaresBindingAnnotation() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.3.3"})
    public void testBindingsDeclaredInJava() {
        Bean<Cat> cat = this.createSimpleBean(Cat.class);
        assert (cat.getBindings().size() == 1);
        assert (Reflections.annotationSetMatches(cat.getBindings(), Synchronous.class));
    }

    @Test
    @SpecAssertion(section={"2.3.3"})
    public void testMultipleBindings() {
        Bean<Cod> model = this.createSimpleBean(Cod.class);
        assert (model.getBindings().size() == 2);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.3.4"})
    public void testBindingsDeclaredInXml() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.3.4"})
    public void testXmlBindingOverridesAndIgnoresJava() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.3.4"})
    public void testNoBindingsDeclaredInXml() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.3.4", "2.3.1"})
    public void testDefaultBindingDeclaredInXml() {
        Bean<Tuna> model = this.createSimpleBean(Tuna.class);
        assert (model.getBindings().size() == 1);
        assert (model.getBindings().contains((Object)new CurrentBinding()));
        assert (false);
    }

    @Test(groups={"injection", "producerMethod"})
    @SpecAssertion(section={"2.3.5"})
    public void testFieldInjectedFromProducerMethod() throws Exception {
        Bean<SpiderProducer> spiderProducer = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Method method = SpiderProducer.class.getMethod("produceTameTarantula", new Class[0]);
        this.manager.addBean(this.createProducerMethodBean(method, spiderProducer));
        Barn barn = (Barn)this.createSimpleBean(Barn.class).create(new MockCreationalContext());
        assert (barn.petSpider != null);
        assert (barn.petSpider instanceof DefangedTarantula);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"2.3.5"})
    public void testFieldWithBindingInXml() {
        assert (false);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"2.3.5"})
    public void testFieldWithBindingInXmlIgnoresAnnotations() {
        assert (false);
    }

    @Test(groups={"injection", "producerMethod"})
    public void testMethodWithBindingAnnotationsOnParametersAreInjected() throws Exception {
        Bean<SpiderProducer> spiderProducer = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Method method = SpiderProducer.class.getMethod("produceTameTarantula", new Class[0]);
        this.manager.addBean(this.createProducerMethodBean(method, spiderProducer));
        method = SpiderProducer.class.getMethod("produceSpiderFromInjection", Tarantula.class);
        Bean spiderBean = this.createProducerMethodBean(method, spiderProducer);
        Spider spider = (Spider)spiderBean.create(new MockCreationalContext());
        assert (spider != null);
        assert (spider instanceof DefangedTarantula);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"2.3.6"})
    public void testMethodWithBindingAnnotationsOnParametersDeclaredInXml() {
        assert (false);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"2.3.6"})
    public void testMethodWithBindingAnnotationsOnParametersDeclaredInXmlIgnoresAnnotations() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testBindingDeclaredInheritedIsInherited() throws Exception {
        Set bindings = this.createSimpleBean(BorderCollie.class).getBindings();
        assert (bindings.size() == 1);
        assert (((Annotation)bindings.iterator().next()).annotationType().equals(Hairy.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testBindingNotDeclaredInheritedIsNotInherited() {
        Set bindings = this.createSimpleBean(ShetlandPony.class).getBindings();
        assert (bindings.size() == 1);
        assert (((Annotation)bindings.iterator().next()).annotationType().equals(Current.class));
    }

    @Test
    @SpecAssertion(section={"4.1"})
    public void testBindingDeclaredInheritedIsBlockedByIntermediateClass() {
        Set bindings = this.createSimpleBean(ClippedBorderCollie.class).getBindings();
        assert (bindings.size() == 1);
        Annotation binding = (Annotation)bindings.iterator().next();
        assert (binding.annotationType().equals(Hairy.class));
        Hairy hairy = (Hairy)binding;
        assert (hairy.clipped());
    }
}

