/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.definition.bean;

import java.lang.reflect.Method;
import javax.context.RequestScoped;
import javax.inject.Production;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.definition.bean.Animal;
import org.jboss.webbeans.tck.unit.definition.bean.DeadlyAnimal;
import org.jboss.webbeans.tck.unit.definition.bean.DeadlySpider;
import org.jboss.webbeans.tck.unit.definition.bean.DependentFinalTuna;
import org.jboss.webbeans.tck.unit.definition.bean.RedSnapper;
import org.jboss.webbeans.tck.unit.definition.bean.Spider;
import org.jboss.webbeans.tck.unit.definition.bean.SpiderProducer;
import org.jboss.webbeans.tck.unit.definition.bean.Tarantula;
import org.testng.annotations.Test;

public class BeanDefinitionTest
extends AbstractTest {
    @Test
    @SpecAssertion(section={"2"})
    public void testApiTypesNonEmpty() {
        Bean<RedSnapper> model = this.createSimpleBean(RedSnapper.class);
        assert (model.getTypes().size() > 0);
    }

    @Test
    @SpecAssertion(section={"2"})
    public void testBindingTypesNonEmpty() {
        Bean<RedSnapper> model = this.createSimpleBean(RedSnapper.class);
        assert (model.getBindings().size() > 0);
    }

    @Test
    @SpecAssertion(section={"2"})
    public void testHasScopeType() {
        Bean<RedSnapper> model = this.createSimpleBean(RedSnapper.class);
        assert (model.getScopeType().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section={"2"})
    public void testHasDeploymentType() {
        Bean<RedSnapper> model = this.createSimpleBean(RedSnapper.class);
        assert (model.getDeploymentType().equals(Production.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section={"5.2"})
    public void testIsNullable() throws Exception {
        Bean<SpiderProducer> spiderProducerBean = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducerBean);
        Method method = SpiderProducer.class.getMethod("getWolfSpiderSize", new Class[0]);
        Bean bean = this.createProducerMethodBean(method, spiderProducerBean);
        assert (!bean.isNullable());
        method = SpiderProducer.class.getMethod("makeASpider", new Class[0]);
        Bean spiderBean = this.createProducerMethodBean(method, spiderProducerBean);
        assert (spiderBean.isNullable());
    }

    @Test
    @SpecAssertion(section={"3.2.2", "2.2"})
    public void testBeanTypes() {
        Bean<Tarantula> bean = this.createSimpleBean(Tarantula.class);
        assert (bean.getTypes().size() == 6);
        assert (bean.getTypes().contains(Tarantula.class));
        assert (bean.getTypes().contains(Spider.class));
        assert (bean.getTypes().contains(Animal.class));
        assert (bean.getTypes().contains(Object.class));
        assert (bean.getTypes().contains(DeadlySpider.class));
        assert (bean.getTypes().contains(DeadlyAnimal.class));
    }

    @Test
    @SpecAssertion(section={"2.2"})
    public void testFinalApiType() {
        this.createSimpleBean(DependentFinalTuna.class);
    }
}

