package org.jboss.webbeans.tck.unit.implementation.simple;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.inject.CreationException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class SimpleBeanLifecycleTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }
	
	@Test(groups="beanConstruction") 
	@SpecAssertion(section="3.2.5.3")
	public void testInjectionOfParametersIntoBeanConstructor()
	{
	   Bean<FishPond> goldfishPondBean = createSimpleBean(FishPond.class);
	   Bean<Goldfish> goldfishBean = createSimpleBean(Goldfish.class);
	   manager.addBean(goldfishBean);
	   manager.addBean(goldfishPondBean);
	   FishPond fishPond = goldfishPondBean.create(new MockCreationalContext<FishPond>());
	   assert fishPond.goldfish != null;
	}
	
	@Test(groups={"stub", "specialization"}) @SpecAssertion(section="3.2.6")
   public void testSpecializedBeanAlwaysUsed()
   {
      // TODO Placeholder
      assert false;
   }
	
   @Test(groups="beanLifecycle") @SpecAssertion(section="5.3")
   public void testCreateReturnsInstanceOfBean()
   {
      Bean<RedSnapper> bean = createSimpleBean(RedSnapper.class);
      assert bean.create(new MockCreationalContext<RedSnapper>()) instanceof RedSnapper;
   }
   
   @Test(groups={"stub", "beanLifecycle", "interceptors"}) 
   @SpecAssertion(section="6.3")
   public void testCreateBindsInterceptorStack()
   {
      assert false;
   }
   
   @Test(groups={"stub", "beanLifecycle", "decorators"}) 
   @SpecAssertion(section="6.3")
   public void testCreateBindsDecoratorStack()
   {
      assert false;
   }
   
   @Test(groups={"stub", "beanLifecycle", "commonAnnotations"}) 
   @SpecAssertion(section="6.3")
   public void testCreateInjectsEjb()
   {
      assert false;
   }
   
   @Test(groups={"stub", "beanLifecycle", "commonAnnotations"}) 
   @SpecAssertion(section="6.3")
   public void testCreateInjectsPersistenceContext()
   {
      assert false;
   }
   
   @Test(groups={"stub", "beanLifecycle", "commonAnnotations"}) 
   @SpecAssertion(section="6.3")
   public void testCreateInjectsResource()
   {
      assert false;
   }
   
   @Test(groups={"beanLifecycle", "lifecycleCallbacks"}) 
   @SpecAssertion(section="6.3")
   public void testPostConstructPreDestroy() throws Exception
   {
      Bean<FarmOffice> farmOfficeBean = createSimpleBean(FarmOffice.class);
      Bean<Farm> farmBean = createSimpleBean(Farm.class);
      manager.addBean(farmOfficeBean);
      manager.addBean(farmBean);
      Farm farm = farmBean.create(new MockCreationalContext<Farm>());
      assert farm.founded!=null;
      assert farm.initialStaff==20;
      assert farm.closed==null;
      farmBean.destroy(farm);
      assert farm.closed!=null;
   }
   
   @Test @SpecAssertion(section="4.2")
   public void testSubClassInheritsPostConstructOnSuperclass() throws Exception
   {
      OrderProcessor.postConstructCalled = false;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Bean<CdOrderProcessor> bean = createSimpleBean(CdOrderProcessor.class);
            bean.create(new MockCreationalContext<CdOrderProcessor>());
         }
      }.run();
      assert OrderProcessor.postConstructCalled;
   }
   
   @Test @SpecAssertion(section="4.2")
   public void testSubClassInheritsPreDestroyOnSuperclass() throws Exception
   {
      OrderProcessor.preDestroyCalled = false;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Bean<CdOrderProcessor> bean = createSimpleBean(CdOrderProcessor.class);
            CdOrderProcessor instance = bean.create(new MockCreationalContext<CdOrderProcessor>());
            bean.destroy(instance);
         }
      }.run();
      assert OrderProcessor.preDestroyCalled;
   }
   
   @Test @SpecAssertion(section="4.2")
   public void testSubClassDoesNotInheritPostConstructOnSuperclassBlockedByIntermediateClass() throws Exception
   {
      
      OrderProcessor.postConstructCalled = false;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Bean<NovelOrderProcessor> bean = createSimpleBean(NovelOrderProcessor.class);
            bean.create(new MockCreationalContext<NovelOrderProcessor>());
         }
      }.run();
      assert !OrderProcessor.postConstructCalled;
   }
   
   @Test @SpecAssertion(section="4.2")
   public void testSubClassDoesNotInheritPreDestroyConstructOnSuperclassBlockedByIntermediateClass() throws Exception
   {
      OrderProcessor.preDestroyCalled = false;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Bean<NovelOrderProcessor> bean = createSimpleBean(NovelOrderProcessor.class);
            NovelOrderProcessor instance = bean.create(new MockCreationalContext<NovelOrderProcessor>());
            bean.destroy(instance);
         }
      }.run();
      assert !OrderProcessor.preDestroyCalled;

   }
   
   @Test(groups="injection") @SpecAssertion(section="6.3")
   public void testCreateInjectsFieldsDeclaredInJava()
   {
      Bean<TunaFarm> tunaFarmBean = createSimpleBean(TunaFarm.class);
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      TunaFarm tunaFarm = tunaFarmBean.create(new MockCreationalContext<TunaFarm>());
      assert tunaFarm.tuna != null;
   }
   
   @Test(groups="injection") 
   public void testFieldMissingBindingAnnotationsAreNotInjected()
   {
      Bean<TunaFarm> tunaFarmBean = createSimpleBean(TunaFarm.class);
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      TunaFarm tunaFarm = tunaFarmBean.create(new MockCreationalContext<TunaFarm>());
      assert tunaFarm.notInjectedTuna != manager.getInstance(tunaBean);
   }
   
   @Test(expectedExceptions=CreationException.class)
   public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() throws Exception
   {
      deployBeans(Lorry_Broken.class);
      new RunInDependentContext()
      {
         
         protected void execute() throws Exception 
         {
            manager.getInstanceByType(Lorry_Broken.class);
         }
         
      }.run();
   }
   
   @Test(expectedExceptions=FooException.class)
   public void testUncheckedExceptionThrownFromCreateNotWrapped() throws Exception
   {
      deployBeans(Van_Broken.class);
      new RunInDependentContext()
      {
         
         protected void execute() throws Exception 
         {
            manager.getInstanceByType(Van_Broken.class);
         }
         
      }.run();
   }
	
}
