package org.jboss.webbeans.tck.unit.implementation.simple;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.implementation.simple.OuterBean_Broken.InnerBean_Broken;
import org.jboss.webbeans.tck.unit.implementation.simple.OuterBean_Broken.StaticInnerBean_Broken;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class SimpleBeanDefinitionTest extends AbstractTest
{   
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }
   
   //*** BEAN CLASS CHECKS ****//
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section="3.2")
   public void testAbstractClassDeclaredInJavaIsNotAllowed()
   {
      createSimpleBean(Cow_Broken.class);
   }
   
   @Test(groups="innerClass") 
   @SpecAssertion(section="3.2")
   public void testStaticInnerClassDeclaredInJavaAllowed()
   {
      createSimpleBean(StaticInnerBean_Broken.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups="innerClass") 
   @SpecAssertion(section="3.2")
   public void testNonStaticInnerClassDeclaredInJavaNotAllowed()
   {
      createSimpleBean(InnerBean_Broken.class);
   }
   
   @SuppressWarnings("unchecked")
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section="3.2")
   public void testParameterizedClassDeclaredInJavaIsNotAllowed()
   {
      createSimpleBean(ParameterizedBean_Broken.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "interceptors", "decorators"}) 
   @SpecAssertion(section="3.2")
   public void testClassCannotBeInterceptorAndDecorator()
   {
      
   }
   
   @Test(groups="stub")
   public void testEntitiesNotDiscoveredAsSimpleBeans()
   {
      assert false;
   }
   
   @Test
   public void testClassesImplementingServletInterfacesNotDiscoveredAsSimpleBeans()
   {
      deployBeans(MockFilter.class, MockHttpSessionListener.class, MockServlet.class, MockServletContextListener.class, MockServletRequestListener.class);
      assert manager.resolveByType(MockFilter.class).size() == 0;
      assert manager.resolveByType(MockHttpSessionListener.class).size() == 0;
      assert manager.resolveByType(MockServlet.class).size() == 0;
      assert manager.resolveByType(MockServletContextListener.class).size() == 0;
      assert manager.resolveByType(MockServletRequestListener.class).size() == 0;
   }
   
   @Test
   public void testClassesImplementingEnterpriseBeanInterfaceNotDiscoveredAsSimpleBean()
   {
      deployBeans(MockEnterpriseBean.class);
      assert manager.resolveByType(MockEnterpriseBean.class).size() == 0;
   }
   
   @Test
   public void testClassExtendingUiComponentNotDiscoveredAsSimpleBean()
   {
      deployBeans(MockUIComponent.class);
      assert manager.resolveByType(MockUIComponent.class).size() == 0;
   }
   
   @Test(groups="stub")
   public void testEjbsNotDiscoveredAsSimpleBean()
   {
      
   }
   
   @Test(groups={"stub", "producerMethod", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testBeanDeclaredInXmlIgnoresProducerMethodDeclaredInJava()
   {
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testBeanDeclaredInXmlIgnoresDisposalMethodDeclaredInJava()
   {
      assert false;
   }
   
   @Test(groups={"stub", "observerMethod", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testBeanDeclaredInXmlIgnoresObserverMethodDeclaredInJava()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testAbstractClassDeclaredInXmlIsNotAllowed()
   {
      
   }
   
   @Test(groups={"stub", "innerClass", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testStaticInnerClassDeclaredInXmlAllowed()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "innerClass", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testNonStaticInnerClassDeclaredInXmlNotAllowed()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="3.2.4")
   public void testParameterizedClassDeclaredInXmlIsNotAllowed()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "interceptors"}) 
   @SpecAssertion(section="3.2.4")
   public void testClassHasInterceptorInJavaMustHaveInterceptorInXml()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "interceptors"}) 
   @SpecAssertion(section="3.2.4")
   public void testClassHasDecoratorInJavaMustHaveDecoratorInXml()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="3.2.5.1")
   public void testInitializerAnnotatedConstructor() throws Exception
   {
      deployBeans(Sheep.class);
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            manager.getInstanceByType(Sheep.class);
            assert Sheep.constructedCorrectly;
            
         }
      }.run();
      
   }
   
   @Test 
   @SpecAssertion(section="3.2.5.1")
   public void testImplicitConstructorUsed()
   {
      Bean<Order> order = createSimpleBean(Order.class);
      // TODO Test this properly!
   }
   
   @Test 
   @SpecAssertion(section="3.2.6.1")
   public void testEmptyConstructorUsed()
   {
      createSimpleBean(Donkey.class).create(new MockCreationalContext<Donkey>());
      assert Donkey.constructedCorrectly;
   }
   
   @Test 
   @SpecAssertion(section="3.2.6.1")
   public void testInitializerAnnotatedConstructorUsedOverEmptyConstuctor() throws Exception
   {
      deployBeans(Turkey.class);
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            manager.getInstanceByType(Turkey.class);
            assert Turkey.constructedCorrectly;
         }
      }.run();
   }
   
   @Test(expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.2.6.1")
   public void testTooManyInitializerAnnotatedConstructor()
   {
      createSimpleBean(Goose_Broken.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.2.6.1")
   public void testConstructorHasDisposesParameter()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "observerMethod"}) 
   @SpecAssertion(section="3.2.6.1")
   public void testConstructorHasObservesParameter()
   {
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="3.2.6.2")
   public void testImplicitConstructorDeclaredInXmlUsed()
   {
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"})  
   @SpecAssertion(section="3.2.6.2")
   public void testEmptyConstructorDeclaredInXmlUsed()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class, groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="3.2.6.2")
   public void testConstructorDeclaredInXmlDoesNotExist()
   {
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="3.2.6.2")
   public void testConstructorDeclaredInXmlIgnoresBindingTypesDeclaredInJava()
   {
      assert false;
   }
   
   @Test 
   @SpecAssertion(section="3.2.6.3")
   public void testBindingTypeAnnotatedConstructor() throws Exception
   {
      deployBeans(Duck.class);
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            manager.getInstanceByType(Duck.class);
            assert Duck.constructedCorrectly;
         }
      }.run();
   }
   
   @Test 
   @SpecAssertion(section="3.2")
   public void testDependentScopedBeanCanHavePublicField() throws Exception
   {
      deployBeans(Tiger.class);
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            assert manager.getInstanceByType(Tiger.class).name.equals("pete");
         }
         
      }.run();
      
   }
   
   @Test(expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.2")
   public void testNonDependentScopedBeanCanNotHavePublicField()
   {
      deployBeans(Leopard_Broken.class);
   }
   
}
