package org.jboss.webbeans.tck.unit.implementation.enterprise;

import java.util.Set;

import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * Sections
 * 
 * 6.5. Lifecycle of stateful session beans
 * 6.6. Lifecycle of stateless session and singleton beans
 * 6.11. Lifecycle of EJBs
 * 
 * Mostly overlapping with other tests...
 * 
 * @author Nicklas Karlsson
 * 
 *  Spec version: PRD2
 */
public class EnterpriseBeanLifecycleTest extends AbstractTest
{
   
   /**
    * When the create() method is called, the Web Bean manager creates and
    * returns an enterprise bean proxy
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "stub" })
   @SpecAssertion(section = "6.5")
   public void testProxyCreated()
   {
      assert false;
   }

   /**
    * When the destroy() method is called, the Web Bean manager calls the Web
    * Bean remove method upon the proxy
    */
   @Test(groups = { "enterpriseBeans", "clientProxy", "lifecycle", "stub"})
   @SpecAssertion(section = "6.5")
   public void testRemoveMethodCalled() throws Exception
   {
      GoodDoggie.destructorCalled = false;
      deployBeans(GoodDoggie.class);
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            Set<Bean<LocalGoodDoggie>> goodDoggieBeans = manager.resolveByType(LocalGoodDoggie.class);
            assert goodDoggieBeans.size() == 1;
            Bean<LocalGoodDoggie> bean = goodDoggieBeans.iterator().next();
            LocalGoodDoggie doggie = manager.getInstance(bean);
            bean.destroy(doggie);
         }
         
      }.run();
   }

   /**
    * For each remove method parameter, the Web Bean manager passes the object
    * returned by Manager.getInstanceByType()
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "removeMethod", "stub" })
   @SpecAssertion(section = "6.5")
   public void testFieldInjections()
   {
      assert false;
   }

   /**
    * If the underlying EJB was already destroyed by direct invocation of a
    * remove method by the application, the Web Bean manager ignores the
    * instance, and is not required to call any remove method
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "removeMethod", "stub" })
   @SpecAssertion(section = "6.5")
   public void testNoRemoveMethodsCalledIfEnterpriseBeanAlreadyRemoved()
   {
      assert false;
   }

   /**
    * When the destroy() method is called, the Web Bean manager simply discards
    * the proxy and all EJB local object references.
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "removeMethod", "stub" })
   @SpecAssertion(section = "6.6")
   public void testProxyAndLocalObjectReferencesDiscardedForStatelessEnterpriseBeans()
   {
      assert false;
   }
   
   /**
    * The Web Bean manager initializes the values of all injected fields. For
    * each injected field, the Web Bean manager sets the value to the object
    * returned by Manager.getInstanceByType().
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "stub" })
   @SpecAssertion(section = "6.11")
   public void testFieldInjectionsOnRemoveMethods()
   {
      assert false;
   }   

   /**
    * Next, if the EJB bean instance is an instance of a Web Bean, the Web Bean
    * manager initializes the values of any fields with initial values specified
    * in XML,
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "stub" })
   @SpecAssertion(section = "6.11")
   public void testInitXMLDefinedValuesOnWebWeanEnterpriseBeans()
   {
      assert false;
   }

   /**
    * Next, the Web Bean manager calls all initializer methods. For each
    * initializer method parameter, the Web Bean manager passes the object
    * returned by Manager.getInstanceByType().
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "stub" })
   @SpecAssertion(section = "6.11")
   public void testInitializerMethodsCalledWithCurrentParameterValues()
   {
      assert false;
   }

   /**
    * Finally, the Web Bean manager builds the interceptor and decorator stacks
    * for the instance
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "interceptors", "stub" })
   @SpecAssertion(section = "6.11")
   public void testInterceptorStackIsBuilt()
   {
      assert false;
   }

   /**
    * Finally, the Web Bean manager builds the interceptor and decorator stacks
    * for the instance
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "decorators", "stub" })
   @SpecAssertion(section = "6.11")
   public void testDecoratorStackIsBuilt()
   {
      assert false;
   }

   /**
    * When the EJB container destroys an instance of an EJB bean, the Web Bean
    * manager intercepts the @PreDestroy callback and destroys all dependent
    * objects, after the callback returns from the bean instance
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "stub" })
   @SpecAssertion(section = "6.11")
   public void testDependentObjectsDestroyed()
   {
      assert false;
   }

}
