package org.jboss.webbeans.tck.unit.definition.stereotype;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.inject.DefinitionException;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class StereotypeDefinitionTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      deploymentTypes.add(HornedAnimalDeploymentType.class);
      return deploymentTypes;
   }
   
   @Test(groups = { "stub", "annotationDefinition" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1")
   public void testHasCorrectTarget()
   {
      assert false;
   }
   
   @Test(groups = { "stub", "annotationDefinition" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1")
   public void testHasCorrectRetention()
   {
      assert false;
   }
   
   @Test(groups = { "stub", "annotationDefinition" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1")
   public void testHasStereotypeAnnotation()
   {
      assert false;
   }
   
   @Test
   @SpecAssertion(section = "2.7.1.1")
   public void testStereotypeWithScopeType()
   {
      Bean<Moose> moose = createSimpleBean(Moose.class);
      assert moose.getScopeType().equals(RequestScoped.class);
   }
   
   @Test
   @SpecAssertion(section = "2.7.1.1")
   public void testStereotypeWithoutScopeType()
   {
      Bean<Reindeer> reindeer = createSimpleBean(Reindeer.class);
      assert reindeer.getScopeType().equals(Dependent.class);
   }
   
   @Test(groups = "stub")
   @SpecAssertion(section = "2.7.1.2")
   public void testStereotypeWithoutInterceptors()
   {
      assert false;
   }
   
   @Test(groups = { "stub", "interceptors" })
   @SpecAssertion(section = "2.7.1.2")
   public void testStereotypeWithInterceptors()
   {
      assert false;
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1.1")
   public void testStereotypeWithTooManyScopeTypes()
   {
      deployBeans(Elk_Broken.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1.1")
   public void testStereotypeWithTooManyDeploymentTypes()
   {
      deployBeans(Gazelle_Broken.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1.3")
   public void testStereotypeWithNonEmptyNamed()
   {
      deployBeans(FallowDeer_Broken.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "2.7.1")
   public void testStereotypeWithBindingTypes()
   {
      deployBeans(RoeDeer_Broken.class);
   }
   
   @Test
   @SpecAssertion(section = { "2.7.2", "2.7.4" })
   public void testMultipleStereotypes()
   {
      Bean<HighlandCow> highlandCow = createSimpleBean(HighlandCow.class);
      assert highlandCow.getName() == null;
      assert highlandCow.getBindings().iterator().next().annotationType().equals(Tame.class);
      assert highlandCow.getScopeType().equals(RequestScoped.class);
      assert highlandCow.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }
   
   @Test
   @SpecAssertion(section = { "2.7.2", "2.7.4" })
   public void testMultipleStereotypesMergesScopes()
   {
      Bean<Springbok> springbok = createSimpleBean(Springbok.class);
      assert springbok.getScopeType().equals(ApplicationScoped.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = { "2.7.2", "2.7.4" })
   public void testMultipleStereotypesMergesRequiredTypes()
   {
      deployBeans(Antelope_Broken.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = { "2.7.2", "2.7.4" })
   public void testMultipleStereotypesWithMultipleDeploymentTypes()
   {
      deployBeans(Goat_Broken.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class, groups = "stub")
   @SpecAssertion(section = { "2.7.2", "2.7.4" })
   public void testMultipleStereotypesWithMultipleScopeTypes()
   {
      assert false;
   }
   
   @Test(groups = { "stub", "webbeansxml" })
   @SpecAssertion(section = "2.7.3")
   public void testStereotypeDeclaredInXmlIgnoresJavaStereotypes()
   {
      // Map<Class<? extends Annotation>, Annotation> cooXmlAnnotations = new
      // HashMap<Class<? extends Annotation>, Annotation>();
      // cooXmlAnnotations.put(HornedMammalStereotype.class, new
      // HornedMamalStereotypeAnnotationLiteral());
      // AnnotatedClass<HighlandCow> cooXmlAnnotatedItem = new
      // SimpleAnnotatedClass<HighlandCow>(HighlandCow.class,
      // cooXmlAnnotations);
      
      /*
       * SimpleBean<HighlandCow> coo = createSimpleBean(HighlandCow.class,
       * cooXmlAnnotatedItem); assert
       * coo.getDeploymentType().equals(HornedAnimalDeploymentType.class);
       * assert coo.getScopeType().equals(RequestScoped.class); assert
       * coo.getMergedStereotypes().getRequiredTypes().size() == 1; assert
       * coo.getMergedStereotypes().getRequiredTypes().contains(Animal.class);
       * assert coo.getMergedStereotypes().getSupportedScopes().size() == 0;
       */
      assert false;
   }
   
   @Test(groups = { "stub", "webbeansxml" })
   @SpecAssertion(section = "2.7.3")
   public void testStereotypeDeclaredInXmlIgnoresJavaBindingTypes()
   {
      // Map<Class<? extends Annotation>, Annotation> cooXmlAnnotations = new
      // HashMap<Class<? extends Annotation>, Annotation>();
      // cooXmlAnnotations.put(HornedMammalStereotype.class, new
      // HornedMamalStereotypeAnnotationLiteral());
      // cooXmlAnnotations.put(Synchronous.class, new
      // SynchronousAnnotationLiteral());
      // AnnotatedClass<HighlandCow> cooXmlAnnotatedItem = new
      // SimpleAnnotatedClass<HighlandCow>(HighlandCow.class,
      // cooXmlAnnotations);
      
      /*
       * SimpleBean<HighlandCow> coo = createSimpleBean(HighlandCow.class,
       * cooXmlAnnotatedItem); assert coo.getBindingTypes().size() == 1; assert
       * coo.getBindingTypes().contains(new SynchronousAnnotationLiteral());
       */
      assert false;
      
   }
   
   @Test
   @SpecAssertion(section = { "2.7.1.4", "2.7.4" })
   public void testRequiredTypeIsImplemented()
   {
      assert createSimpleBean(HighlandCow.class).getTypes().contains(Animal.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = { "2.7.1.4", "2.7.4" })
   public void testRequiredTypeIsNotImplemented()
   {
      deployBeans(Chair_Broken.class);
   }
   
   @Test
   @SpecAssertion(section = { "2.7.1.4", "2.7.4" })
   public void testScopeIsSupported()
   {
      assert createSimpleBean(Goldfish.class).getScopeType().equals(RequestScoped.class);
   }
   
   @Test(expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = { "2.7.1.4", "2.7.4" })
   public void testScopeIsNotSupported()
   {
      createSimpleBean(Carp_Broken.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testStereotypeDeclaredInheritedIsInherited() throws Exception
   {
      assert createSimpleBean(BorderCollie.class).getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testStereotypeNotDeclaredInheritedIsNotInherited()
   {
      assert createSimpleBean(ShetlandPony.class).getDeploymentType().equals(Production.class);
   }
   
}
