package org.jboss.webbeans.tck.unit.context;

import static org.jboss.webbeans.tck.impl.WebBeansTCKImpl.configuration;

import java.lang.annotation.Annotation;

import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.RequestScoped;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
public class ContextTest extends AbstractTest
{
   
   private @interface Dummy
   {
      
   }
   
   private @interface Unregistered
   {      
      
   }
   
   private static class DummyContext implements Context
   {

      public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext)
      {
         throw new UnsupportedOperationException();
      }
      
      public <T> T get(Contextual<T> contextual)
      {
         return get(contextual, null);
      }

      public Class<? extends Annotation> getScopeType()
      {
         return Dummy.class;
      }

      public boolean isActive()
      {
         return true;
      }      
   }
      
   @Test(expectedExceptions={ContextNotActiveException.class}, groups={"manager"}) @SpecAssertion(section="8.5")
   public void testGetContextWithNoActiveContextsFails()
   {
      configuration().getContexts().setInactive(configuration().getContexts().getRequestContext());
      manager.getContext(RequestScoped.class);
   }

   @Test(expectedExceptions={IllegalArgumentException.class}, groups={"manager"}) @SpecAssertion(section="8.5")
   public void testGetContextWithTooManyActiveContextsFails()
   {
      Context firstContext = new DummyContext() {};
      Context secondContext = new DummyContext() {};
      manager.addContext(firstContext);
      manager.addContext(secondContext);
      manager.getContext(Dummy.class);
   }

   @Test(expectedExceptions={ContextNotActiveException.class}, groups={"manager"}) @SpecAssertion(section="8.5")
   public void testGetContextWithNoRegisteredContextsFails()
   {
      manager.getContext(Unregistered.class);
   }

   @Test(groups={"manager"}) @SpecAssertion(section="8.5")
   public void testGetContextReturnsActiveContext()
   {
      manager.getContext(RequestScoped.class);
   }
   
   /**
    * For each of the built-in normal scopes, contexts propagate across any Java
    * method call, including invocation of EJB local business methods.
    */
   @Test(groups = { "stub", "contexts" })
   @SpecAssertion(section = "8.5")
   public void testBuiltInNormalScopedContextsPropagateAcrossAnyJavaMethodCall()
   {
      assert false;
   }

   /**
    * The built-in contexts do not propagate across remote method invocations or
    * to asynchronous processes such as JMS message listeners or EJB timer
    * service timeouts
    */
   @Test(groups = { "stub", "contexts" })
   @SpecAssertion(section = "8.5")
   public void testBuiltInNormalScopedContextsDoNotPropagateAcrossRemoteMethodInvocations()
   {
      assert false;
   }

   /**
    * The built-in contexts do not propagate across remote method invocations or
    * to asynchronous processes such as JMS message listeners or EJB timer
    * service timeouts
    */
   @Test(groups = { "stub", "contexts" })
   @SpecAssertion(section = "8.5")
   public void testBuiltInNormalScopedContextsDoNotPropagateAcrossAsynchronousMethodInvocations()
   {
      assert false;
   }   
   
}
