/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeLiteral<T> {
    private Type actualType;

    protected TypeLiteral() {
        Class<?> typeLiteralSubclass = TypeLiteral.getTypeLiteralSubclass(this.getClass());
        if (typeLiteralSubclass == null) {
            throw new RuntimeException(this.getClass() + " is not a subclass of TypeLiteral");
        }
        this.actualType = TypeLiteral.getTypeParameter(typeLiteralSubclass);
        if (this.actualType == null) {
            throw new RuntimeException(this.getClass() + " is missing type parameter in TypeLiteral");
        }
    }

    public final Type getType() {
        return this.actualType;
    }

    public final Class<T> getRawType() {
        Type type = this.getType();
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        throw new RuntimeException("Illegal type");
    }

    private static Class<?> getTypeLiteralSubclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.equals(TypeLiteral.class)) {
            return clazz;
        }
        if (superclass.equals(Object.class)) {
            return null;
        }
        return TypeLiteral.getTypeLiteralSubclass(superclass);
    }

    private static Type getTypeParameter(Class<?> superclass) {
        ParameterizedType parameterizedType;
        Type type = superclass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }
}

