/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.jbossas.vdf;

import javax.servlet.ServletContext;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.webbeans.integration.jbossas.vdf.AbstractVDFConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanVDFConnector<U, T>
extends AbstractVDFConnector<U, Kernel> {
    private ControllerState state;

    public AbstractBeanVDFConnector(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected Class<Kernel> getAttributeType() {
        return Kernel.class;
    }

    @Override
    protected String getAttributeKey() {
        return "jboss.kernel:service=Kernel";
    }

    protected abstract Object getBeanKey();

    protected abstract Class<T> getBeanType();

    protected abstract Class<U> getUnwrappedType();

    protected U unwrap(T bean) {
        Class<U> unwrappedType = this.getUnwrappedType();
        if (!unwrappedType.isInstance(bean)) {
            throw new IllegalArgumentException("Bean " + bean + " is not instance of " + unwrappedType);
        }
        return unwrappedType.cast(bean);
    }

    @Override
    protected U getUtilityFromAttribute(Kernel kernel) {
        KernelController controller = kernel.getController();
        ControllerContext context = this.state == null ? controller.getContext(this.getBeanKey(), this.state) : controller.getInstalledContext(this.getBeanKey());
        if (context == null) {
            return null;
        }
        Object target = context.getTarget();
        Class<T> beanType = this.getBeanType();
        if (!beanType.isInstance(target)) {
            throw new IllegalArgumentException("Bean " + target + " is not instance of " + beanType);
        }
        return this.unwrap(beanType.cast(target));
    }

    public void setState(ControllerState state) {
        this.state = state;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("bean=").append(this.getBeanKey());
        if (this.state != null) {
            builder.append(", state=").append(this.state);
        }
        return builder.toString();
    }
}

