package org.jboss.webbeans.integration.jbossas.bootstrap;


import javax.servlet.ServletContext;

import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.bootstrap.spi.helpers.ForwardingWebBeanDiscovery;
import org.jboss.webbeans.integration.jbossas.vdf.plugins.WebBeanDiscoveryEnvVDFConnector;

public class ServletJBossWebBeanDiscovery extends ForwardingWebBeanDiscovery
{   
  
   private final WebBeanDiscovery delegate;
   
   public ServletJBossWebBeanDiscovery(ServletContext servletContext)
   {
      WebBeanDiscoveryEnvVDFConnector connector = new WebBeanDiscoveryEnvVDFConnector(servletContext);
      if (connector.isValid() == false)
         throw new IllegalArgumentException("Cannot find web-beans discovery in deployment: " + servletContext);

      this.delegate = new JBossWebBeanDiscovery(connector.getUtility());
   }

   @Override
   protected WebBeanDiscovery delegate()
   {
      return delegate;
   }
   
}
