package org.jboss.webbeans.integration.ejb;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.integration.util.Reflections;

public abstract class JBossEJBDescriptorAdaptor<T> implements EjbDescriptor<T>
{
   private final Class<T> type;
   private final String ejbName;

   public JBossEJBDescriptorAdaptor(JBossEnterpriseBeanMetaData enterpriseBeanMetaData, DeploymentUnit deploymentUnit, EjbReferenceResolver resolver)
   {
      try
      {
         this.type = (Class<T>) Reflections.classForName(enterpriseBeanMetaData.getEjbClass(), deploymentUnit.getClassLoader());
      }
      catch (ClassCastException e) 
      {
         throw new IllegalStateException("Error loading EJB Session bean class", e);
      }
      catch (ClassNotFoundException e)
      {
         throw new IllegalStateException("Cannot load EJB Session bean class", e);
      }
      
      this.ejbName = enterpriseBeanMetaData.getEjbName();
   }

   public Class<T> getType()
   {
      return type;
   }

   public String getEjbName()
   {
      return ejbName;
   }
   
   @Override
   public String toString()
   {
      StringBuilder builder = new StringBuilder();
      builder.append(getEjbName());
      if (isStateful())
      {
         builder.append(" (SFSB)");
      }
      if (isStateless())
      {
         builder.append(" (SLSB)");
      }
      if (isSingleton())
      {
         builder.append(" (Singleton)");
      }
      if (isMessageDriven())
      {
         builder.append(" (MDB)");
      }
      builder.append("; BeanClass: " + getType() + "; Local Business Interfaces: " + getLocalBusinessInterfaces());
      return builder.toString(); 
   }
   
   @Override
   public boolean equals(Object other)
   {
      if (other instanceof EjbDescriptor)
      {
         EjbDescriptor<T> that = (EjbDescriptor<T>) other;
         return this.getEjbName().equals(that.getEjbName());
      }
      else
      {
         return false;
      }
   }
   
   @Override
   public int hashCode()
   {
      return getEjbName().hashCode();
   }   
}