/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.test.framework.embedded.apacheds;

/*
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.jboss.system.ServiceMBeanSupport;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import java.io.File;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
*/


/**
 * XMBean Service for ApacheDS integration
 * <p/>
 * based on code snippets taken from apache directory examples from http://docs.safehaus.org/display/APACHEDS/Embedding+ApacheDS
 * https://svn.safehaus.org/repos/sandbox/apachecon/ by akarasulu@apache.org
 *
 * @author <a href="mailto:Boleslaw dot Dawidowicz at jboss dot com">Boleslaw Dawidowicz</a>
 * @version $Revision$
 * @since Sep 29, 2006
 */
public class ApacheDSService //extends ServiceMBeanSupport implements ApacheDSServiceMBean
{
   /*public static String objectName = "portal.test:service=ApacheDSService";

   private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(ApacheDSService.class);

   private String workingDir = null;

   private boolean removeWorkingDir = false;

   private String importInitialLdif = null;

   private String loadLdif = null;

   private int port = 10389;


   *//**
    * Print some information about the DS (eg: connections etc)
    *
    * @return String
    *//*
   public String printDiagnostics()
   {
      StringBuffer sb = new StringBuffer();
      sb.append("staticstics not exposed yet");
      return sb.toString();
   }

   public void startService() throws Exception
   {
      super.startService();

      // Server start time
      long startTime = System.currentTimeMillis();

      MutableServerStartupConfiguration configuration = getConfiguration();

      Hashtable env = createEnvironment();

      // Put extended configuration into environment
      env.put(Configuration.JNDI_KEY, configuration);


      try
      {
         // Startup the server core by getting the first InitialDirContext.
         InitialDirContext ictx = new InitialDirContext(env);
         log.info("Embedded ApacheDS started in " + (System.currentTimeMillis() - startTime) + " milliseconds");

         // Access the suffix for the new naming context
         Attributes attrs = ictx.getAttributes("");
         log.info("Attributes for ou=system: " + attrs.toString());

         ClassLoader tcl = Thread.currentThread().getContextClassLoader();

         //load initial ldif
         if (loadLdif != null)
         {
            try
            {

               URL ldif = tcl.getResource(loadLdif);
               log.info("ldif to load by loader: " + ldif.getPath());

               LdifFileLoader loader = new LdifFileLoader(ictx, ldif.getPath());
               loader.execute();
            }
            catch (Exception e)
            {
               log.info("Unable to load ldif");
               e.printStackTrace();
            }
         }
      }
      catch (NamingException e)
      {
         log.error("Failed to start the server.", e);
      }

   }

   public void stopService() throws Exception
   {
      log.info("Stopping Embedded ApacheDS ...");

      //Create a configuration instruction.
      ShutdownConfiguration cfg = new ShutdownConfiguration();

      //Build the properties from bean attributes
      Hashtable env = createEnvironment();

      // Put the configuration instruction to the environment variable.
      env.putAll(cfg.toJndiEnvironment());

      new InitialDirContext(env);

      if (removeWorkingDir)
      {
         log.info("ApachDS working directory " + (deleteDir(new File(workingDir)) ? "removed" : "not removed") + " on exit");
      }
   }


   private MutableServerStartupConfiguration getConfiguration() throws Exception
   {

      MutableServerStartupConfiguration configuration = new MutableServerStartupConfiguration();

      // Enable networking but turn off every other service but LDAP on port 10389
      configuration.setEnableNetworking(true);
      configuration.setAccessControlEnabled(false);
      configuration.setAllowAnonymousAccess(false);
      configuration.setEnableChangePassword(false);
      configuration.setEnableKerberos(false);
      configuration.setEnableNtp(false);
      configuration.setLdapPort(port);

      workingDir = configuration.getWorkingDirectory().getAbsolutePath();

      log.info("ApacheDS working dir: " + workingDir);

      ClassLoader tcl = Thread.currentThread().getContextClassLoader();

      if (importInitialLdif != null)
      {

         try
         {

            URL ldif = tcl.getResource(importInitialLdif);
            log.info("ldif to load: " + ldif.getPath());
            configuration.setLdifDirectory(new File(ldif.getPath()));
         }
         catch (Exception e)
         {
            log.info("Unable to load ldif for startup");
            e.printStackTrace();
         }
      }


      MutablePartitionConfiguration partition = new MutablePartitionConfiguration();

      // Set the name of the partition
      partition.setName("org");

      // Set the suffix off of which this partition hangs in the DIT all entries stored
      // within this partition will have this suffix in their distinguished names
      partition.setSuffix("dc=org");

      //Set indices
      Set indices = new HashSet();
      indices.add("objectClass");
      indices.add("ou");
      indices.add("dc");
      partition.setIndexedAttributes(indices);

      // Assemble the partition's suffix entry
      Attributes suffixEntry = new BasicAttributes("objectClass", "top", true);
      suffixEntry.get("objectClass").add("organizationalUnit");
      suffixEntry.get("objectClass").add("dcObject");
      suffixEntry.get("objectClass").add("domain");
      suffixEntry.get("objectClass").add("extensibleObject");

      suffixEntry.put("dc", "org");

      partition.setContextEntry(suffixEntry);

      // Add the new partition configuration to the configuration bean
      Set partitions = new HashSet();
      partitions.add(partition);
      configuration.setContextPartitionConfigurations(partitions);

      return configuration;
   }

   private Hashtable createEnvironment()
   {
      Hashtable env = new Hashtable();

      // Notice that the provider URL is not really a URL but a DN
      env.put(Context.PROVIDER_URL, "ou=system");

      // User the ApacheDS server InitialContextFactory implementation
      env.put(Context.INITIAL_CONTEXT_FACTORY, "org.apache.directory.server.jndi.ServerContextFactory");

      // Fixed uber admin user is always present and initial password is set to "secret"
      env.put(Context.SECURITY_PRINCIPAL, "uid=admin,ou=system");
      env.put(Context.SECURITY_CREDENTIALS, "secret");
      env.put(Context.SECURITY_AUTHENTICATION, "simple");

      return env;
   }

   public static boolean deleteDir(File dir)
   {
      if (dir.isDirectory())
      {
         String[] children = dir.list();
         for (int i = 0; i < children.length; i++)
         {
            boolean success = deleteDir(new File(dir, children[i]));
            if (!success)
            {
               return false;
            }
         }
      }

      return dir.delete();
   }


   public boolean isRemoveWorkingDir()
   {
      return removeWorkingDir;
   }

   public void setRemoveWorkingDir(boolean removeWorkingDir)
   {
      this.removeWorkingDir = removeWorkingDir;
   }

   public String getLoadLdif()
   {
      return loadLdif;
   }

   public void setLoadLdif(String loadLdif)
   {
      this.loadLdif = loadLdif;
   }

   public int getPort()
   {
      return port;
   }

   public void setPort(int port)
   {
      this.port = port;
   }

   public String getImportInitialLdif()
   {
      return importInitialLdif;
   }

   public void setImportInitialLdif(String importInitialLdif)
   {
      this.importInitialLdif = importInitialLdif;
   }


   *//**
    * A GetSystemPropetyAction.
    *
    * @author <a href="anil.saldhana@jboss.com">Anil Saldhana</a>
    * @version $Revision: 1.1 $
    *//*
   public class GetSystemPropertyAction implements PrivilegedAction
   {
      private String property;

      public GetSystemPropertyAction(String prop)
      {
         this.property = prop;
      }

      public Object run()
      {
         return System.getProperty(property);
      }
   }*/

}
