/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.embedded.opends;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.jboss.portal.test.framework.embedded.opends.OpenDSServiceMBean;
import org.opends.server.core.DirectoryServer;

public class OpenDSService
implements OpenDSServiceMBean {
    private static final Logger log = Logger.getLogger(OpenDSService.class);
    public static String objectName = "portal.test:service=OpenDSService";
    private String newline = (String)AccessController.doPrivileged(new GetSystemPropertyAction("line.separator"));

    public String printDiagnostics() {
        StringBuffer sb = new StringBuffer();
        sb.append("Maximum concurrent client connections allowed:");
        sb.append(DirectoryServer.getMaxAllowedConnections());
        sb.append(this.newline).append("# of client connections currently established:");
        sb.append(DirectoryServer.getCurrentConnections());
        return sb.toString();
    }

    public void restart() {
        DirectoryServer.restart((String)this.getClass().getName(), (String)"DS restart");
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        this.startService();
    }

    public void startService() throws Exception {
        String confLoc = (String)AccessController.doPrivileged(new GetSystemPropertyAction("jboss.server.config.url"));
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        URL ldif = tcl.getResource("opends/config/config.ldif");
        log.info((Object)("OpenDS config ldif = " + ldif.getPath()));
        String[] strArr = new String[]{"--configClass", "org.opends.server.config.ConfigFileHandler", "--configFile", ldif.getPath()};
        DirectoryServer.main((String[])strArr);
    }

    public void stop() throws Exception {
        this.stopService();
    }

    public void stopService() throws Exception {
        log.info((Object)"Asking DS to shutdown");
        DirectoryServer.shutDown((String)this.getClass().getName(), (String)"Shut down DS");
    }

    public void destroy() throws Exception {
    }

    public class GetSystemPropertyAction
    implements PrivilegedAction {
        private String property;

        public GetSystemPropertyAction(String prop) {
            this.property = prop;
        }

        public Object run() {
            return System.getProperty(this.property);
        }
    }
}

