/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.unit.tooling.maven2;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jboss.unit.tooling.maven2.configuration.Reports;
import org.jboss.unit.tooling.maven2.configuration.Testsuite;

/**
 * @author <a href="mailto:boleslaw dot dawidowicz at redhat anotherdot com">Boleslaw Dawidowicz</a>
 * @goal execute
 * @version : 0.1 $
 */
public class UnitMojo extends AbstractMojo
{

   public static final String MAVEN_SKIP_TEST = "maven.test.skip";

   /**
    * @parameter
    */
   private Testsuite[] testsuites;

   /**
    * @parameter
    */
   private Reports reports;

   /**
    * @parameter
    */
   private boolean jpda;

   /**
    * @parameter
    */
   private String jpdaPort;

   /**
    * @parameter
    */
   private String jpdaSuspend = "true";

   /**
    * @parameter
    */
   private boolean useJUL = true;

   /**
    * @parameter
    */
   private boolean fork = true;

   /**
    * @parameter
    */
   private boolean assertions = true;

   /**
    * @parameter
    */
   private boolean failOnError = false;

   /**
    * The Maven project object
    *
    * @parameter expression="${project}"
    */
   private MavenProject project;


   public void execute()
      throws MojoExecutionException
   {

      String testSkip = (String)System.getProperties().get(MAVEN_SKIP_TEST);

      // Skip tests
      if (testSkip != null && testSkip.equalsIgnoreCase("true"))
      {
         //TODO: make it logging

         System.out.println("Skipping test execution: " + MAVEN_SKIP_TEST + " set to true");

         return;
      }

      //Invoke all configured testsuites

      for (Testsuite testsuite : testsuites)
      {
         // Propagate global reports settings if needed
         if (testsuite.getReports() == null && reports != null)
         {
            testsuite.setReports(reports);
         }
         
         TestSuiteExecutor executor = new TestSuiteExecutor(project, testsuite, this);
         try
         {
            executor.execute();
         }
         catch (Exception e)
         {
            throw new MojoExecutionException("Build failed",e);
         }
      }
       
   }

   public boolean isJpda()
   {
      return jpda;
   }

   public String getJpdaPort()
   {
      return jpdaPort;
   }

   public String getJpdaSuspend()
   {
      return jpdaSuspend;
   }

   public boolean isUseJUL()
   {
      return useJUL;
   }

   public void setUseJUL(boolean useJUL)
   {
      this.useJUL = useJUL;
   }

   public boolean isFork()
   {
      return fork;
   }

   public void setFork(boolean fork)
   {
      this.fork = fork;
   }

   public boolean isAssertions()
   {
      return assertions;
   }

   public void setAssertions(boolean assertions)
   {
      this.assertions = assertions;
   }

   public boolean isFailOnError()
   {
      return failOnError;
   }

   public void setFailOnError(boolean failOnError)
   {
      this.failOnError = failOnError;
   }

   

   
}
