/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.test.framework.server.Node;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.command.StartTestCommand;
import org.jboss.unit.driver.response.EndTestResponse;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.remote.RequestContext;
import org.jboss.unit.remote.ResponseContext;
import org.jboss.unit.remote.driver.ProtocolHandler;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.RemoteTestDriver;
import org.jboss.unit.remote.driver.RemoteTestDriverClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestConversation {
    private final TestId testId;
    private final RemoteTestDriverClient driver;
    private final Map<String, Object> attributes;
    private Node node;
    private Map<String, String> parametrization;
    private ProtocolHandler protocolHandler;

    public TestConversation(ProtocolHandler protocolHandler, RemoteTestDriverClient driver, TestId testId, Node node) {
        this.protocolHandler = protocolHandler;
        this.driver = driver;
        this.testId = testId;
        this.node = node;
        this.attributes = new HashMap<String, Object>();
    }

    DriverResponse handleCommand(DriverCommand command) throws Exception {
        RemoteDriverCommandContext commandContext = new RemoteDriverCommandContext(command);
        return this.handleCommand(commandContext);
    }

    public final DriverResponse handleCommand(RemoteDriverCommandContext commandContext) throws Exception {
        RemoteDriverResponseContext respCtx;
        DriverCommand command = commandContext.getCommand();
        if (command instanceof StartTestCommand) {
            StartTestCommand start = (StartTestCommand)command;
            this.parametrization = start.getParametrization();
            this.pushContext(commandContext);
            DriverResponse response = this.getDriver().getServer(this.node).invoke(this.testId, command);
            respCtx = commandContext.createResponseContext(response);
        } else {
            respCtx = this.protocolHandler.handleCommand(this, commandContext);
        }
        DriverResponse response = respCtx.getResponse();
        if (response instanceof EndTestResponse || response instanceof FailureResponse) {
            return response;
        }
        commandContext = this.protocolHandler.handleResponse(this, respCtx);
        if (commandContext == null) {
            return new FailureResponse(Failure.createErrorFailure((String)("Response " + response + " was not handled")));
        }
        return this.handleCommand(commandContext);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public RemoteTestDriverClient getDriver() {
        return this.driver;
    }

    public TestId getTestId() {
        return this.testId;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Map<String, String> getParametrization() {
        return this.parametrization;
    }

    public void setParametrization(Map<String, String> parametrization) {
        this.parametrization = parametrization;
    }

    public void pushContext(RemoteDriverCommandContext commandContext) {
        RequestContext ctx = new RequestContext(commandContext.getRequestCount(), this.parametrization, commandContext.getPayload());
        RemoteTestDriver agent = this.driver.getServer(this.node);
        agent.pushContext(this.testId, ctx);
    }

    public ResponseContext popContext() {
        RemoteTestDriver agent = this.driver.getServer(this.node);
        return agent.popContext(this.testId);
    }
}

