/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.handler.http.response;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.unit.remote.driver.handler.http.response.HTTPDriverResponse;
import org.jboss.unit.remote.http.HttpHeader;
import org.jboss.unit.remote.http.HttpHeaders;

public abstract class InvokeMethodResponse
extends HTTPDriverResponse {
    private URI uri;
    private HttpHeaders headers;

    public InvokeMethodResponse(String uri) throws IllegalArgumentException {
        URI tmp;
        if (uri == null) {
            throw new IllegalArgumentException("Cannot invoke against a null URL");
        }
        try {
            tmp = new URI(uri);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Wrong URI syntax");
            iae.initCause(e);
            throw iae;
        }
        if (tmp.isOpaque()) {
            throw new IllegalArgumentException("No opaque URI accepted");
        }
        this.uri = tmp;
        this.headers = new HttpHeaders();
    }

    public InvokeMethodResponse(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot invoke against a null URL");
        }
        this.uri = uri;
        this.headers = new HttpHeaders();
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeader addHeader(String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("No null header name accepted");
        }
        return this.headers.addHeader(headerName);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

