/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver;

import java.net.URL;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.portal.test.framework.deployment.Deployer;
import org.jboss.portal.test.framework.server.Node;
import org.jboss.portal.test.framework.server.NodeId;
import org.jboss.portal.test.framework.server.NodeManager;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverContext;
import org.jboss.unit.driver.DriverException;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.command.StartTestCommand;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.impl.SimpleTestInfo;
import org.jboss.unit.remote.driver.ProtocolHandler;
import org.jboss.unit.remote.driver.RemoteTestDriver;
import org.jboss.unit.remote.driver.TestCaseFactory;
import org.jboss.unit.remote.driver.TestConversation;

public class RemoteTestDriverClient
extends BasicBootstrap
implements TestDriver {
    private static Logger log = Logger.getLogger(RemoteTestDriverClient.class);
    private SimpleTestInfo info;
    private DriverContext context;
    private NodeManager nodeManager;
    private ProtocolHandler protocolHandler;
    private String archivePath;
    private String serverName;
    private Deployer deployer;
    private KernelDeployment deployment;
    private BeanXMLDeployer beanDeployer;

    public String getArchivePath() {
        return this.archivePath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Inject(bean="NodeManager")
    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    @Inject(bean="DeployerHandler")
    public void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    @Inject(bean="Deployer")
    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public RemoteTestDriver getServer(Node node) {
        return (RemoteTestDriver)node.lookupService("TestDriverServer");
    }

    public void initDriver(DriverContext context) throws DriverException {
        this.context = context;
        this.archivePath = context.getProperty("archivePath");
        this.serverName = context.getProperty("serverName");
        log.debug((Object)"Initializing remote test driving client");
        log.debug((Object)("Archive path = " + this.archivePath));
        log.debug((Object)("Server name = " + this.serverName));
        log.debug((Object)"Booting kernel");
        this.run();
        try {
            log.debug((Object)"Installing TestDriver bean");
            AbstractBeanMetaData bmd = new AbstractBeanMetaData("TestDriver", ((Object)((Object)this)).getClass().getName());
            AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
            bmd.setConstructor((ConstructorMetaData)cmd);
            TestCaseFactory factory = new TestCaseFactory((Object)this);
            AbstractValueMetaData vmd = new AbstractValueMetaData((Object)factory);
            cmd.setFactory((ValueMetaData)vmd);
            cmd.setFactoryMethod("getTestCase");
            this.getKernel().getController().install((BeanMetaData)bmd);
        }
        catch (Throwable throwable) {
            throw new DriverException("Could not install the TestDriver bean", throwable);
        }
        try {
            String location = "/org/jboss/unit/remote/driver/jboss-beans.xml";
            URL url = ((Object)((Object)this)).getClass().getResource(location);
            if (url == null) {
                log.debug((Object)("The file jboss-beans.xml supposed to be located under " + location + " could not be found"));
            }
            log.debug((Object)("Now deploying the beans with url " + url));
            this.beanDeployer = new BeanXMLDeployer(this.getKernel());
            this.deployment = this.beanDeployer.deploy(url);
            this.beanDeployer.validate();
            String archiveId = context.getProperty("archiveId");
            if (archiveId != null) {
                log.debug((Object)("Going to deploy " + archiveId));
                Node node = this.nodeManager.getNode(NodeId.DEFAULT);
                this.deployer.deploy(this.archivePath, archiveId, node);
            } else {
                log.debug((Object)"No archive id was provided");
            }
        }
        catch (Throwable throwable) {
            throw new DriverException("Could not deploy the beans", throwable);
        }
        Node node = this.nodeManager.getNode(NodeId.DEFAULT);
        RemoteTestDriver server = this.getServer(node);
        server.initDriver(context);
        this.info = SimpleTestInfo.create((TestInfo)server.getInfo());
    }

    public void destroyDriver() {
        try {
            Node node = this.nodeManager.getNode(NodeId.DEFAULT);
            RemoteTestDriver server = this.getServer(node);
            server.destroyDriver();
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        try {
            this.beanDeployer.undeploy(this.deployment);
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        this.context = null;
    }

    public TestInfo getInfo() {
        return this.info;
    }

    public DriverResponse invoke(TestId testId, DriverCommand command) {
        if (command instanceof StartTestCommand) {
            try {
                Node node = this.nodeManager.getNode(NodeId.DEFAULT);
                TestConversation conversation = this.createConversation(testId, node);
                return conversation.handleCommand(command);
            }
            catch (Exception e) {
                return new FailureResponse(Failure.createFailure((Throwable)e));
            }
        }
        return new FailureResponse(Failure.createErrorFailure((String)("Command " + command + " not accepted")));
    }

    protected TestConversation createConversation(TestId testId, Node node) {
        return new TestConversation(this.protocolHandler, this, testId, node);
    }

    public Node getNode(int port) {
        NodeId nodeId = null;
        switch (port) {
            case 8080: {
                nodeId = NodeId.DEFAULT;
                break;
            }
            case 8180: {
                nodeId = NodeId.PORTS_01;
                break;
            }
            case 8280: {
                nodeId = NodeId.PORTS_02;
            }
        }
        return this.nodeManager.getNode(nodeId);
    }

    public int getPort(Node node) {
        NodeId nodeId = node.getId();
        if (NodeId.DEFAULT.equals((Object)nodeId)) {
            return 8080;
        }
        if (NodeId.PORTS_01.equals((Object)nodeId)) {
            return 8180;
        }
        if (NodeId.PORTS_02.equals((Object)nodeId)) {
            return 8280;
        }
        return -1;
    }
}

