/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver;

import java.io.Serializable;
import java.util.HashMap;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverContext;
import org.jboss.unit.driver.DriverException;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.impl.SimpleTestSuiteInfo;
import org.jboss.unit.remote.RequestContext;
import org.jboss.unit.remote.ResponseContext;
import org.jboss.unit.remote.driver.RemoteTestDriver;

public class RemoteTestDriverServer
implements RemoteTestDriver {
    private RemoteTestDriver delegate;

    public RemoteTestDriver getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RemoteTestDriver delegate) {
        this.delegate = delegate;
    }

    public void initDriver(DriverContext context) throws DriverException {
        this.delegate.initDriver(context);
    }

    public void destroyDriver() {
        this.delegate.destroyDriver();
    }

    public TestInfo getInfo() {
        if (this.delegate == null) {
            return new SimpleTestSuiteInfo("Empty");
        }
        return this.delegate.getInfo();
    }

    public DriverResponse invoke(TestId id, DriverCommand command) {
        if (this.delegate == null) {
            return new FailureResponse(Failure.createErrorFailure((String)("No such test with id " + id)));
        }
        return this.delegate.invoke(id, command);
    }

    public void pushContext(TestId testId, RequestContext requestContext) {
        if (this.delegate != null) {
            this.delegate.pushContext(testId, requestContext);
        }
    }

    public ResponseContext popContext(TestId testId) {
        if (this.delegate != null) {
            return this.delegate.popContext(testId);
        }
        return new ResponseContext((DriverResponse)new FailureResponse(Failure.createErrorFailure((String)("No test found for " + testId))), new HashMap<String, Serializable>());
    }
}

