/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.remote.driver.handler.deployer;

import org.jboss.unit.remote.driver.ProtocolHandler;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.handler.deployer.response.UndeployResponse;
import org.jboss.unit.remote.driver.handler.deployer.response.DeployResponse;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.portal.test.framework.deployment.Deployer;
import org.jboss.portal.test.framework.server.Node;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class DeployerHandler implements ProtocolHandler
{

   /** . */
   private ProtocolHandler nextHandler;

   /** . */
   private Deployer deployer;

   /** . */
   private String archivePath;

   public ProtocolHandler getNextHandler()
   {
      return nextHandler;
   }

   public void setNextHandler(ProtocolHandler nextHandler)
   {
      this.nextHandler = nextHandler;
   }

   public Deployer getDeployer()
   {
      return deployer;
   }

   public void setDeployer(Deployer deployer)
   {
      this.deployer = deployer;
   }

   public String getArchivePath()
   {
      return archivePath;
   }

   public void setArchivePath(String archivePath)
   {
      this.archivePath = archivePath;
   }

   public RemoteDriverCommandContext handleResponse(TestConversation testConversation, RemoteDriverResponseContext responseContext)
   {
      DriverResponse response = responseContext.getResponse();

      if (response instanceof DeployResponse)
      {
         DeployResponse deploy = (DeployResponse)response;

         Node node = testConversation.getNode();

         //
         try
         {
            deployer.deploy(archivePath, deploy.getId(), node);
         }
         catch (Exception e)
         {
            throw new Error(e);
         }

         //
         return new RemoteDriverCommandContext(responseContext.getCommandContext());
      }
      else if (response instanceof UndeployResponse)
      {
         UndeployResponse undeploy = (UndeployResponse)response;

         //
         try
         {
            deployer.undeploy(archivePath, undeploy.getId());
         }
         catch (Exception e)
         {
            throw new Error(e);
         }

         //
         return new RemoteDriverCommandContext(responseContext.getCommandContext());
      }

      //
      if (nextHandler != null)
      {
         return nextHandler.handleResponse(testConversation, responseContext);
      }

      //
      return null;
   }

   public RemoteDriverResponseContext handleCommand(TestConversation conversation, RemoteDriverCommandContext commandContext) throws Exception
   {
      if (nextHandler != null)
      {
         return nextHandler.handleCommand(conversation, commandContext);
      }

      //
      return null;
   }
}
