/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.remote.driver;

import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.DriverContext;
import org.jboss.unit.driver.DriverException;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.impl.composite.AbstractCompositeTestDriver;
import org.jboss.unit.driver.impl.composite.CompositeTestDriver;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.remote.RequestContext;
import org.jboss.unit.remote.ResponseContext;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class CompositeRemoteTestDriver implements RemoteTestDriver
{

   /** . */
   private AbstractCompositeTestDriver delegate;

   public CompositeRemoteTestDriver(String name)
   {
      this(new CompositeTestDriver(name));
   }

   public CompositeRemoteTestDriver(AbstractCompositeTestDriver delegate)
   {
      this.delegate = delegate;
   }

   public void initDriver(DriverContext context) throws DriverException
   {
      delegate.initDriver(context);
   }

   public void destroyDriver()
   {
      delegate.destroyDriver();
   }

   public TestInfo getInfo()
   {
      return delegate.getInfo();
   }

   public DriverResponse invoke(TestId id, DriverCommand command)
   {
      return delegate.invoke(id, command);
   }

   public void pushContext(TestId testId, RequestContext requestContext)
   {
      String name = testId.getName(0);

      //
      TestDriver driver = delegate.getDriver(name);

      //
      if (driver instanceof RemoteTestDriver)
      {
         RemoteTestDriver remoteDriver = (RemoteTestDriver)driver;

         //
         remoteDriver.pushContext(testId.range(1), requestContext);
      }
   }

   public ResponseContext popContext(TestId testId)
   {
      String name = testId.getName(0);

      //
      TestDriver driver = delegate.getDriver(name);

      //
      if (driver instanceof RemoteTestDriver)
      {
         RemoteTestDriver remoteDriver = (RemoteTestDriver)driver;

         //
         return remoteDriver.popContext(testId.range(1));
      }

      //
      return new ResponseContext(new FailureResponse(Failure.createErrorFailure("No test found for " + testId)), new HashMap<String, Serializable>());
   }
}
