/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver;

import java.io.Serializable;
import java.util.HashMap;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverContext;
import org.jboss.unit.driver.DriverException;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.impl.composite.AbstractCompositeTestDriver;
import org.jboss.unit.driver.impl.composite.CompositeTestDriver;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.remote.RequestContext;
import org.jboss.unit.remote.ResponseContext;
import org.jboss.unit.remote.driver.RemoteTestDriver;

public class CompositeRemoteTestDriver
implements RemoteTestDriver {
    private AbstractCompositeTestDriver delegate;

    public CompositeRemoteTestDriver(String name) {
        this((AbstractCompositeTestDriver)new CompositeTestDriver(name));
    }

    public CompositeRemoteTestDriver(AbstractCompositeTestDriver delegate) {
        this.delegate = delegate;
    }

    public void initDriver(DriverContext context) throws DriverException {
        this.delegate.initDriver(context);
    }

    public void destroyDriver() {
        this.delegate.destroyDriver();
    }

    public TestInfo getInfo() {
        return this.delegate.getInfo();
    }

    public DriverResponse invoke(TestId id, DriverCommand command) {
        return this.delegate.invoke(id, command);
    }

    public void pushContext(TestId testId, RequestContext requestContext) {
        String name = testId.getName(0);
        TestDriver driver = this.delegate.getDriver(name);
        if (driver instanceof RemoteTestDriver) {
            RemoteTestDriver remoteDriver = (RemoteTestDriver)driver;
            remoteDriver.pushContext(testId.range(1), requestContext);
        }
    }

    public ResponseContext popContext(TestId testId) {
        String name = testId.getName(0);
        TestDriver driver = this.delegate.getDriver(name);
        if (driver instanceof RemoteTestDriver) {
            RemoteTestDriver remoteDriver = (RemoteTestDriver)driver;
            return remoteDriver.popContext(testId.range(1));
        }
        return new ResponseContext((DriverResponse)new FailureResponse(Failure.createErrorFailure((String)("No test found for " + testId))), new HashMap<String, Serializable>());
    }
}

