/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public class VerificationWithTimeoutImpl {
    VerificationMode delegate;
    int timeout;
    int treshhold;

    public VerificationWithTimeoutImpl(int treshhold, int millis, VerificationMode delegate) {
        this.treshhold = treshhold;
        this.timeout = millis;
        this.delegate = delegate;
    }

    public void verify(VerificationData data) {
        int soFar = 0;
        MockitoAssertionError error = null;
        while (soFar <= this.timeout) {
            try {
                this.delegate.verify(data);
                return;
            }
            catch (MockitoAssertionError e) {
                error = e;
                soFar += this.treshhold;
                this.sleep(this.treshhold);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    void sleep(int sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {}
    }

    public VerificationMode getDelegate() {
        return this.delegate;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTreshhold() {
        return this.treshhold;
    }
}

