/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.invocation.Invocation;

public class MatchersBinder
implements Serializable {
    private static final long serialVersionUID = -311433939339443463L;

    public InvocationMatcher bindMatchers(ArgumentMatcherStorage argumentMatcherStorage, Invocation invocation) {
        List<Matcher> lastMatchers = argumentMatcherStorage.pullLocalizedMatchers();
        this.validateMatchers(invocation, lastMatchers);
        InvocationMatcher invocationWithMatchers = new InvocationMatcher(invocation, lastMatchers);
        return invocationWithMatchers;
    }

    private void validateMatchers(Invocation invocation, List<LocalizedMatcher> lastMatchers) {
        if (!lastMatchers.isEmpty()) {
            int recordedMatchersSize = lastMatchers.size();
            int expectedMatchersSize = invocation.getArguments().length;
            if (expectedMatchersSize != recordedMatchersSize) {
                new Reporter().invalidUseOfMatchers(expectedMatchersSize, lastMatchers);
            }
        }
    }
}

