/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.exceptions.stacktrace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mockito.exceptions.stacktrace.StackTraceCleaner;
import org.mockito.internal.configuration.ClassPathLoader;
import org.mockito.internal.exceptions.stacktrace.DefaultStackTraceCleaner;

public class StackTraceFilter
implements Serializable {
    static final long serialVersionUID = -5499819791513105700L;
    private static StackTraceCleaner cleaner = ClassPathLoader.getStackTraceCleanerProvider().getStackTraceCleaner(new DefaultStackTraceCleaner());

    public StackTraceElement[] filter(StackTraceElement[] target, boolean keepTop) {
        List<StackTraceElement> unfilteredStackTrace = Arrays.asList(target);
        int lastBad = -1;
        int firstBad = -1;
        int i = 0;
        while (i < unfilteredStackTrace.size()) {
            if (cleaner.isOut(unfilteredStackTrace.get(i))) {
                lastBad = i;
                if (firstBad == -1) {
                    firstBad = i;
                }
            }
            ++i;
        }
        List<Object> top = keepTop && firstBad != -1 ? unfilteredStackTrace.subList(0, firstBad) : new LinkedList();
        List<StackTraceElement> bottom = unfilteredStackTrace.subList(lastBad + 1, unfilteredStackTrace.size());
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>(top);
        filtered.addAll(bottom);
        return filtered.toArray(new StackTraceElement[0]);
    }
}

