/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.List;
import org.mockito.internal.debugging.LoggingListener;
import org.mockito.internal.debugging.WarningsFinder;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.internal.util.SimpleMockitoLogger;
import org.mockito.invocation.Invocation;

public class WarningsPrinterImpl {
    private final boolean warnAboutUnstubbed;
    private WarningsFinder finder;

    public WarningsPrinterImpl(List<Invocation> unusedStubs, List<InvocationMatcher> unstubbedInvocations) {
        this(unusedStubs, unstubbedInvocations, false);
    }

    public WarningsPrinterImpl(List<Invocation> unusedStubs, List<InvocationMatcher> allInvocations, boolean warnAboutUnstubbed) {
        this(warnAboutUnstubbed, new WarningsFinder(unusedStubs, allInvocations));
    }

    WarningsPrinterImpl(boolean warnAboutUnstubbed, WarningsFinder finder) {
        this.warnAboutUnstubbed = warnAboutUnstubbed;
        this.finder = finder;
    }

    public void print(MockitoLogger logger) {
        this.finder.find(new LoggingListener(this.warnAboutUnstubbed, logger));
    }

    public String print() {
        SimpleMockitoLogger logger = new SimpleMockitoLogger();
        this.print(logger);
        return logger.getLoggedInfo();
    }
}

