/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.jmock;

import java.util.ArrayList;
import java.util.List;

public class SearchingClassLoader
extends ClassLoader {
    private final ClassLoader nextToSearch;

    public SearchingClassLoader(ClassLoader parent, ClassLoader nextToSearch) {
        super(parent);
        this.nextToSearch = nextToSearch;
    }

    public static ClassLoader combineLoadersOf(Class<?> ... classes) {
        return SearchingClassLoader.combineLoadersOf(classes[0], classes);
    }

    private static ClassLoader combineLoadersOf(Class<?> first, Class<?> ... others) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        SearchingClassLoader.addIfNewElement(loaders, first.getClassLoader());
        Class<?>[] classArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            SearchingClassLoader.addIfNewElement(loaders, c.getClassLoader());
            ++n2;
        }
        SearchingClassLoader.addIfNewElement(loaders, SearchingClassLoader.class.getClassLoader());
        SearchingClassLoader.addIfNewElement(loaders, Thread.currentThread().getContextClassLoader());
        return SearchingClassLoader.combine(loaders);
    }

    private static ClassLoader combine(List<ClassLoader> parentLoaders) {
        ClassLoader loader = parentLoaders.get(parentLoaders.size() - 1);
        int i = parentLoaders.size() - 2;
        while (i >= 0) {
            loader = new SearchingClassLoader(parentLoaders.get(i), loader);
            --i;
        }
        return loader;
    }

    private static void addIfNewElement(List<ClassLoader> loaders, ClassLoader c) {
        if (c != null && !loaders.contains(c)) {
            loaders.add(c);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.nextToSearch != null) {
            return this.nextToSearch.loadClass(name);
        }
        return super.findClass(name);
    }
}

