/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.MockSettings;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.debugging.VerboseMockInvocationLogger;
import org.mockito.internal.util.MockCreationValidator;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.MockitoSpy;
import org.mockito.internal.util.collections.Sets;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.stubbing.Answer;

public class MockSettingsImpl<T>
extends CreationSettings<T>
implements MockSettings,
MockCreationSettings<T> {
    private static final long serialVersionUID = 4475297236197939568L;

    @Override
    public MockSettings serializable() {
        this.serializable = true;
        return this;
    }

    public MockSettings extraInterfaces(Class ... extraInterfaces) {
        if (extraInterfaces == null || extraInterfaces.length == 0) {
            new Reporter().extraInterfacesRequiresAtLeastOneInterface();
        }
        Class[] classArray = extraInterfaces;
        int n = extraInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class i = classArray[n2];
            if (i == null) {
                new Reporter().extraInterfacesDoesNotAcceptNullParameters();
            } else if (!i.isInterface()) {
                new Reporter().extraInterfacesAcceptsOnlyInterfaces(i);
            }
            ++n2;
        }
        this.extraInterfaces = Sets.newSet(extraInterfaces);
        return this;
    }

    @Override
    public MockName getMockName() {
        return this.mockName;
    }

    @Override
    public Set<Class> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    @Override
    public Object getSpiedInstance() {
        return this.spiedInstance;
    }

    @Override
    public MockSettings name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MockSettings spiedInstance(Object spiedInstance) {
        this.spiedInstance = spiedInstance;
        return this;
    }

    @Override
    public MockSettings defaultAnswer(Answer defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
        return this;
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return this.defaultAnswer;
    }

    @Override
    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public MockSettings verboseLogging() {
        if (!this.invocationListenersContainsType(VerboseMockInvocationLogger.class)) {
            this.invocationListeners(new VerboseMockInvocationLogger());
        }
        return this;
    }

    @Override
    public MockSettings invocationListeners(InvocationListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            new Reporter().invocationListenersRequiresAtLeastOneListener();
        }
        InvocationListener[] invocationListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            InvocationListener listener = invocationListenerArray[n2];
            if (listener == null) {
                new Reporter().invocationListenerDoesNotAcceptNullParameters();
            }
            this.invocationListeners.add(listener);
            ++n2;
        }
        return this;
    }

    private boolean invocationListenersContainsType(Class<?> clazz) {
        for (InvocationListener listener : this.invocationListeners) {
            if (!listener.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<InvocationListener> getInvocationListeners() {
        return this.invocationListeners;
    }

    public boolean hasInvocationListeners() {
        return !this.invocationListeners.isEmpty();
    }

    @Override
    public Class<T> getTypeToMock() {
        return this.typeToMock;
    }

    public MockCreationSettings<T> confirm(Class<T> typeToMock) {
        return MockSettingsImpl.validatedSettings(typeToMock, this);
    }

    private static <T> CreationSettings<T> validatedSettings(Class<T> typeToMock, CreationSettings<T> source) {
        MockCreationValidator validator = new MockCreationValidator();
        validator.validateType(typeToMock);
        validator.validateExtraInterfaces(typeToMock, source.getExtraInterfaces());
        validator.validateMockedType(typeToMock, source.getSpiedInstance());
        CreationSettings<T> settings = new CreationSettings<T>(source);
        settings.setMockName(new MockNameImpl(source.getName(), typeToMock));
        settings.setTypeToMock(typeToMock);
        settings.setExtraInterfaces(MockSettingsImpl.prepareExtraInterfaces(source));
        return settings;
    }

    private static Set<Class> prepareExtraInterfaces(CreationSettings settings) {
        HashSet<Class> interfaces = new HashSet<Class>(settings.getExtraInterfaces());
        if (settings.isSerializable()) {
            interfaces.add(Serializable.class);
        }
        if (settings.getSpiedInstance() != null) {
            interfaces.add(MockitoSpy.class);
        }
        return interfaces;
    }
}

