/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection.scanner;

import java.lang.reflect.Field;
import java.util.Set;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.collections.Sets;
import org.mockito.internal.util.reflection.FieldReader;

public class MockScanner {
    private MockUtil mockUtil = new MockUtil();
    private final Object instance;
    private final Class<?> clazz;

    public MockScanner(Object instance, Class<?> clazz) {
        this.instance = instance;
        this.clazz = clazz;
    }

    public void addPreparedMocks(Set<Object> mocks) {
        mocks.addAll(this.scan());
    }

    private Set<Object> scan() {
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        Field[] fieldArray = this.clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            FieldReader fieldReader = new FieldReader(this.instance, field);
            Object mockInstance = this.preparedMock(fieldReader.read(), field);
            if (mockInstance != null) {
                mocks.add(mockInstance);
            }
            ++n2;
        }
        return mocks;
    }

    private Object preparedMock(Object instance, Field field) {
        if (this.isAnnotatedByMockOrSpy(field)) {
            return instance;
        }
        if (this.isMockOrSpy(instance)) {
            this.mockUtil.maybeRedefineMockName(instance, field.getName());
            return instance;
        }
        return null;
    }

    private boolean isAnnotatedByMockOrSpy(Field field) {
        return field.getAnnotation(Spy.class) != null || field.getAnnotation(Mock.class) != null || field.getAnnotation(MockitoAnnotations.Mock.class) != null;
    }

    private boolean isMockOrSpy(Object instance) {
        return this.mockUtil.isMock(instance) || this.mockUtil.isSpy(instance);
    }
}

