/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection.scanner;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.exceptions.Reporter;

public class InjectMocksScanner {
    private final Class<?> clazz;

    public InjectMocksScanner(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void addTo(Set<Field> mockDependentFields) {
        mockDependentFields.addAll(this.scan());
    }

    private Set<Field> scan() {
        Field[] fields;
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Field[] fieldArray = fields = this.clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getAnnotation(InjectMocks.class) != null) {
                this.assertNoAnnotations(field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
                mockDependentFields.add(field);
            }
            ++n2;
        }
        return mockDependentFields;
    }

    void assertNoAnnotations(Field field, Class ... annotations) {
        Class[] classArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Class annotation = classArray[n2];
            if (field.isAnnotationPresent(annotation)) {
                new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), InjectMocks.class.getSimpleName());
            }
            ++n2;
        }
    }
}

