/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

public class SpyAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return null;
    }

    @Override
    public void process(Class<?> context, Object testInstance) {
        Field[] fields;
        Field[] fieldArray = fields = context.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(Spy.class) && !field.isAnnotationPresent(InjectMocks.class)) {
                this.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
                Object instance = null;
                try {
                    FieldInitializationReport report = new FieldInitializer(testInstance, field).initialize();
                    instance = report.fieldInstance();
                }
                catch (MockitoException e) {
                    new Reporter().cannotInitializeForSpyAnnotation(field.getName(), e);
                }
                try {
                    if (new MockUtil().isMock(instance)) {
                        Mockito.reset(instance);
                    } else {
                        field.setAccessible(true);
                        field.set(testInstance, Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
                    }
                }
                catch (IllegalAccessException e) {
                    throw new MockitoException("Problems initiating spied field " + field.getName(), e);
                }
            }
            ++n2;
        }
    }

    void assertNoIncompatibleAnnotations(Class annotation, Field field, Class ... undesiredAnnotations) {
        Class[] classArray = undesiredAnnotations;
        int n = undesiredAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Class u = classArray[n2];
            if (field.isAnnotationPresent(u)) {
                new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
            }
            ++n2;
        }
    }
}

