/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.mockito.internal.util.collections.Sets;

public class InjectingAnnotationEngine
implements AnnotationEngine {
    private AnnotationEngine delegate = new DefaultAnnotationEngine();
    private AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    @Deprecated
    public Object createMockFor(Annotation annotation, Field field) {
        return this.delegate.createMockFor(annotation, field);
    }

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.processInjectMocks(testInstance.getClass(), testInstance);
    }

    private void processInjectMocks(Class<?> clazz, Object testInstance) {
        Class<?> classContext = clazz;
        while (classContext != Object.class) {
            this.injectMocks(testInstance);
            classContext = classContext.getSuperclass();
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        Class<?> classContext = clazz;
        while (classContext != Object.class) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
            classContext = classContext.getSuperclass();
        }
    }

    public void injectMocks(Object testClassInstance) {
        Class<?> clazz = testClassInstance.getClass();
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        while (clazz != Object.class) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new MockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
            clazz = clazz.getSuperclass();
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
    }
}

