/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ArithmeticExpression10;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class ArithmeticExpression
extends BinaryExpression {
    private Calculator calculator;
    protected boolean simplified = false;
    private AtomicType itemType = null;

    public ArithmeticExpression(Expression p0, int operator, Expression p1) {
        super(p0, operator, p1);
    }

    public String getExpressionName() {
        return "arithmetic";
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        AtomicValue val;
        if (this.simplified) {
            return this;
        }
        this.simplified = true;
        Expression e = super.simplify(visitor);
        if (e == this && visitor.getStaticContext().isInBackwardsCompatibleMode()) {
            return new ArithmeticExpression10(this.operand0, this.operator, this.operand1);
        }
        if (this.operator == 299 && Literal.isAtomic(this.operand1) && (val = (AtomicValue)((Literal)this.operand1).getValue()) instanceof NumericValue) {
            return Literal.makeLiteral(((NumericValue)val).negate());
        }
        return e;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        SequenceType atomicType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, false, role0, visitor);
        ItemType itemType0 = this.operand0.getItemType(th);
        if (itemType0 instanceof ErrorType) {
            return Literal.makeEmptySequence();
        }
        AtomicType type0 = (AtomicType)itemType0.getPrimitiveItemType();
        if (type0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.operand0 = UntypedSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), this.operand0, BuiltInAtomicType.DOUBLE);
            type0 = BuiltInAtomicType.DOUBLE;
        } else if ((this.operand0.getSpecialProperties() & 0x2000000) == 0 && th.relationship(type0, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.operand0 = UntypedSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), this.operand0, BuiltInAtomicType.DOUBLE);
            type0 = (AtomicType)this.operand0.getItemType(th).getPrimitiveItemType();
        }
        RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, false, role1, visitor);
        ItemType itemType1 = this.operand1.getItemType(th);
        if (itemType1 instanceof ErrorType) {
            return Literal.makeEmptySequence();
        }
        AtomicType type1 = (AtomicType)itemType1.getPrimitiveItemType();
        if (type1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.operand1 = UntypedSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), this.operand1, BuiltInAtomicType.DOUBLE);
            type1 = BuiltInAtomicType.DOUBLE;
        } else if ((this.operand1.getSpecialProperties() & 0x2000000) == 0 && th.relationship(type1, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.operand1 = UntypedSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), this.operand1, BuiltInAtomicType.DOUBLE);
            type1 = (AtomicType)this.operand1.getItemType(th).getPrimitiveItemType();
        }
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeEmptySequence();
        }
        if (type0.isExternalType() || type1.isExternalType()) {
            XPathException de = new XPathException("Arithmetic operators are not defined for external objects");
            de.setLocator(this);
            de.setErrorCode("XPTY0004");
            throw de;
        }
        if (this.operator == 299) {
            if (this.operand1 instanceof Literal && ((Literal)this.operand1).getValue() instanceof NumericValue) {
                NumericValue nv = (NumericValue)((Literal)this.operand1).getValue();
                return Literal.makeLiteral(nv.negate());
            }
            NegateExpression ne = new NegateExpression(this.operand1);
            ne.setBackwardsCompatible(false);
            return visitor.typeCheck(ne, contextItemType);
        }
        boolean mustResolve = !type0.equals(BuiltInAtomicType.ANY_ATOMIC) && !type1.equals(BuiltInAtomicType.ANY_ATOMIC) && !type0.equals(BuiltInAtomicType.NUMERIC) && !type1.equals(BuiltInAtomicType.NUMERIC);
        this.calculator = Calculator.getCalculator(type0.getFingerprint(), type1.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), mustResolve);
        if (this.calculator == null) {
            XPathException de = new XPathException("Arithmetic operator is not defined for arguments of types (" + type0.getDescription() + ", " + type1.getDescription() + ")");
            de.setLocator(this);
            de.setErrorCode("XPTY0004");
            throw de;
        }
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                return Literal.makeLiteral(SequenceTool.toGroundedValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
            }
        }
        catch (XPathException err) {
            // empty catch block
        }
        return this;
    }

    public IntegerValue[] getIntegerBounds() {
        IntegerValue[] bounds0 = this.operand0.getIntegerBounds();
        IntegerValue[] bounds1 = this.operand1.getIntegerBounds();
        if (bounds0 == null || bounds1 == null) {
            return null;
        }
        switch (this.operator) {
            case 15: {
                return new IntegerValue[]{bounds0[0].plus(bounds1[0]), bounds0[1].plus(bounds1[1])};
            }
            case 16: {
                return new IntegerValue[]{bounds0[0].minus(bounds1[1]), bounds0[1].minus(bounds1[0])};
            }
            case 17: {
                if (this.operand1 instanceof Literal) {
                    IntegerValue val1 = bounds1[0];
                    if (val1.signum() > 0) {
                        return new IntegerValue[]{bounds0[0].times(val1), bounds0[1].times(val1)};
                    }
                    return null;
                }
                if (this.operand0 instanceof Literal) {
                    IntegerValue val0 = bounds1[0];
                    if (val0.signum() > 0) {
                        return new IntegerValue[]{bounds1[0].times(val0), bounds1[1].times(val0)};
                    }
                    return null;
                }
            }
            case 18: 
            case 56: {
                IntegerValue val1;
                if (this.operand1 instanceof Literal && (val1 = bounds1[0]).signum() > 0) {
                    try {
                        return new IntegerValue[]{bounds0[0].idiv(val1), bounds0[1].idiv(val1)};
                    }
                    catch (XPathException e) {
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Expression copy() {
        ArithmeticExpression ae = new ArithmeticExpression(this.operand0.copy(), this.operator, this.operand1.copy());
        ae.calculator = this.calculator;
        ae.simplified = this.simplified;
        return ae;
    }

    public static AtomicValue compute(AtomicValue value0, int operator, AtomicValue value1, XPathContext context) throws XPathException {
        int p0 = value0.getPrimitiveType().getFingerprint();
        int p1 = value1.getPrimitiveType().getFingerprint();
        Calculator calculator = Calculator.getCalculator(p0, p1, operator, false);
        return calculator.compute(value0, value1, context);
    }

    public static int mapOpCode(int op) {
        switch (op) {
            case 15: {
                return 0;
            }
            case 16: 
            case 299: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 3;
            }
            case 56: {
                return 5;
            }
            case 19: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemType getItemType(TypeHierarchy th) {
        AtomicType resultType;
        ItemType t2;
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType t1 = this.operand0.getItemType(th);
        if (!(t1 instanceof AtomicType)) {
            t1 = t1.getAtomizedItemType();
        }
        if (!((t2 = this.operand1.getItemType(th)) instanceof AtomicType)) {
            t2 = t2.getAtomizedItemType();
        }
        if ((resultType = this.calculator.getResultType((AtomicType)t1.getPrimitiveItemType(), (AtomicType)t2.getPrimitiveItemType())).equals(BuiltInAtomicType.ANY_ATOMIC) && (this.operator == 15 || this.operator == 16) && (th.isSubType(t2, BuiltInAtomicType.NUMERIC) || th.isSubType(t1, BuiltInAtomicType.NUMERIC))) {
            resultType = BuiltInAtomicType.NUMERIC;
        }
        this.itemType = resultType;
        return this.itemType;
    }

    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        this.itemType = null;
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
        if (v0 == null) {
            return null;
        }
        AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v1 == null) {
            return null;
        }
        try {
            return this.calculator.compute(v0, v1, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }
}

