/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.xqj.SaxonXQItemType;

public class SaxonXQStaticContext
implements XQStaticContext {
    private Configuration config;
    private int bindingMode = 0;
    private int holdability = 1;
    private int scrollability = 1;
    private Map namespaces = new HashMap();
    private String baseURI = "";
    boolean preserveBoundarySpace = false;
    boolean constructionModeIsPreserve = false;
    boolean inheritNamespaces = true;
    boolean preserveNamespaces = true;
    boolean emptyLeast = true;
    boolean isOrdered = true;
    SaxonXQItemType contextItemStaticType = null;
    String defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    String defaultElementNamespace = "";
    String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";

    public SaxonXQStaticContext(Configuration config) {
        this.config = config;
    }

    public SaxonXQStaticContext(SaxonXQStaticContext sc) {
        this.config = sc.config;
        this.bindingMode = sc.bindingMode;
        this.holdability = sc.holdability;
        this.scrollability = sc.scrollability;
        this.namespaces = new HashMap(sc.namespaces);
        this.baseURI = sc.baseURI;
        this.preserveBoundarySpace = sc.preserveBoundarySpace;
        this.constructionModeIsPreserve = sc.constructionModeIsPreserve;
        this.inheritNamespaces = sc.inheritNamespaces;
        this.preserveNamespaces = sc.preserveNamespaces;
        this.emptyLeast = sc.emptyLeast;
        this.isOrdered = sc.isOrdered;
        this.contextItemStaticType = sc.contextItemStaticType;
        this.defaultCollationName = sc.defaultCollationName;
        this.defaultElementNamespace = sc.defaultElementNamespace;
        this.defaultFunctionNamespace = sc.defaultFunctionNamespace;
    }

    protected StaticQueryContext getSaxonStaticQueryContext() {
        StaticQueryContext sqc = this.config.newStaticQueryContext();
        sqc.setSchemaAware(this.config.isLicensedFeature(1));
        sqc.setBaseURI(this.baseURI);
        sqc.setConstructionMode(this.constructionModeIsPreserve ? 3 : 4);
        sqc.setDefaultElementNamespace(this.defaultElementNamespace);
        sqc.setDefaultFunctionNamespace(this.defaultFunctionNamespace);
        sqc.setEmptyLeast(this.emptyLeast);
        sqc.setInheritNamespaces(this.inheritNamespaces);
        sqc.setPreserveBoundarySpace(this.preserveBoundarySpace);
        sqc.setPreserveNamespaces(this.preserveNamespaces);
        if (this.contextItemStaticType != null) {
            sqc.setRequiredContextItemType(this.contextItemStaticType.getSaxonItemType());
        }
        for (String prefix : this.namespaces.keySet()) {
            String uri = (String)this.namespaces.get(prefix);
            sqc.declareNamespace(prefix, uri);
        }
        return sqc;
    }

    @Override
    public void declareNamespace(String prefix, String uri) throws XQException {
        this.checkNotNull(prefix);
        this.checkNotNull(uri);
        if (uri.length() == 0) {
            this.namespaces.remove(prefix);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public int getBindingMode() {
        return this.bindingMode;
    }

    @Override
    public int getBoundarySpacePolicy() {
        return this.preserveBoundarySpace ? 1 : 2;
    }

    @Override
    public int getConstructionMode() {
        return this.constructionModeIsPreserve ? 1 : 2;
    }

    @Override
    public XQItemType getContextItemStaticType() {
        return this.contextItemStaticType;
    }

    @Override
    public int getCopyNamespacesModeInherit() {
        return this.inheritNamespaces ? 1 : 2;
    }

    @Override
    public int getCopyNamespacesModePreserve() {
        return this.preserveNamespaces ? 1 : 2;
    }

    @Override
    public String getDefaultCollation() {
        return this.defaultCollationName;
    }

    @Override
    public String getDefaultElementTypeNamespace() {
        return this.defaultElementNamespace;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    @Override
    public int getDefaultOrderForEmptySequences() {
        return this.emptyLeast ? 2 : 1;
    }

    @Override
    public String[] getNamespacePrefixes() {
        String[] result = new String[this.namespaces.size()];
        Iterator iter = this.namespaces.keySet().iterator();
        int i = 0;
        while (i < result.length) {
            iter.hasNext();
            result[i] = (String)iter.next();
            ++i;
        }
        return result;
    }

    @Override
    public String getNamespaceURI(String prefix) throws XQException {
        this.checkNotNull(prefix);
        String uri = (String)this.namespaces.get(prefix);
        if (uri == null) {
            throw new XQException("Unknown prefix");
        }
        return uri;
    }

    @Override
    public int getOrderingMode() {
        return this.isOrdered ? 1 : 2;
    }

    @Override
    public int getHoldability() {
        return this.holdability;
    }

    @Override
    public int getQueryLanguageTypeAndVersion() {
        return 1;
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public int getScrollability() {
        return this.scrollability;
    }

    @Override
    public void setBaseURI(String baseUri) throws XQException {
        this.checkNotNull(baseUri);
        this.baseURI = baseUri;
    }

    @Override
    public void setBindingMode(int bindingMode) throws XQException {
        switch (bindingMode) {
            case 0: 
            case 1: {
                this.bindingMode = bindingMode;
                break;
            }
            default: {
                throw new XQException("Invalid value for binding mode - " + bindingMode);
            }
        }
    }

    @Override
    public void setBoundarySpacePolicy(int policy) throws XQException {
        switch (policy) {
            case 1: {
                this.preserveBoundarySpace = true;
                break;
            }
            case 2: {
                this.preserveBoundarySpace = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for boundary space policy - " + policy);
            }
        }
    }

    @Override
    public void setConstructionMode(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.constructionModeIsPreserve = true;
                break;
            }
            case 2: {
                this.constructionModeIsPreserve = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for construction mode - " + mode);
            }
        }
    }

    @Override
    public void setContextItemStaticType(XQItemType contextItemType) {
        this.contextItemStaticType = (SaxonXQItemType)contextItemType;
    }

    @Override
    public void setCopyNamespacesModeInherit(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.inheritNamespaces = true;
                break;
            }
            case 2: {
                this.inheritNamespaces = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for namespaces inherit mode - " + mode);
            }
        }
    }

    @Override
    public void setCopyNamespacesModePreserve(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.preserveNamespaces = true;
                break;
            }
            case 2: {
                this.preserveNamespaces = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for namespaces preserve mode - " + mode);
            }
        }
    }

    @Override
    public void setDefaultCollation(String uri) throws XQException {
        this.checkNotNull(uri);
        this.defaultCollationName = uri;
    }

    @Override
    public void setDefaultElementTypeNamespace(String uri) throws XQException {
        this.checkNotNull(uri);
        this.defaultElementNamespace = uri;
    }

    @Override
    public void setDefaultFunctionNamespace(String uri) throws XQException {
        this.checkNotNull(uri);
        this.defaultFunctionNamespace = uri;
    }

    @Override
    public void setDefaultOrderForEmptySequences(int order) throws XQException {
        switch (order) {
            case 1: {
                this.emptyLeast = false;
                break;
            }
            case 2: {
                this.emptyLeast = true;
                break;
            }
            default: {
                throw new XQException("Invalid value for default order for empty sequences - " + order);
            }
        }
    }

    @Override
    public void setOrderingMode(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.isOrdered = true;
                break;
            }
            case 2: {
                this.isOrdered = false;
                break;
            }
            default: {
                throw new XQException("Invalid ordering mode - " + mode);
            }
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws XQException {
        if (seconds < 0) {
            throw new XQException("Query timeout must not be negative");
        }
    }

    @Override
    public void setHoldability(int holdability) throws XQException {
        switch (holdability) {
            case 1: 
            case 2: {
                this.holdability = holdability;
                break;
            }
            default: {
                throw new XQException("Invalid holdability value - " + holdability);
            }
        }
    }

    @Override
    public void setQueryLanguageTypeAndVersion(int langtype) throws XQException {
        if (langtype != 1) {
            throw new XQException("XQueryX is not supported");
        }
    }

    @Override
    public void setScrollability(int scrollability) throws XQException {
        switch (scrollability) {
            case 1: 
            case 2: {
                this.scrollability = scrollability;
                break;
            }
            default: {
                throw new XQException("Invalid scrollability value - " + scrollability);
            }
        }
    }

    protected void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }
}

