/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SingletonItem;
import net.sf.saxon.xqj.SaxonXQDataFactory;

public class SaxonXQItemType
implements XQItemType {
    private ItemType itemType;
    private Configuration config;

    protected SaxonXQItemType(ItemType itemType, Configuration config) {
        this.itemType = itemType;
        this.config = config;
    }

    protected SaxonXQItemType(NodeInfo node) {
        this.config = node.getConfiguration();
        this.itemType = new SingletonItem(node).getItemType(this.config.getTypeHierarchy());
    }

    @Override
    public int getBaseType() throws XQException {
        if (this.itemType instanceof AtomicType) {
            AtomicType at = (AtomicType)this.itemType;
            while (!at.isBuiltInType()) {
                at = (AtomicType)at.getBaseType();
            }
            return SaxonXQDataFactory.mapSaxonTypeToXQJ(at.getFingerprint());
        }
        if (this.itemType instanceof NodeTest) {
            NodeTest it = (NodeTest)this.itemType;
            if (it instanceof DocumentNodeTest) {
                it = ((DocumentNodeTest)it).getElementTest();
            }
            if ((it.getNodeKindMask() & 0x2388) != 0) {
                throw new XQException("Wrong node kind for getBaseType()");
            }
            SchemaType contentType = it.getContentType();
            if (contentType.isAtomicType()) {
                AtomicType at = (AtomicType)contentType;
                while (!at.isBuiltInType()) {
                    at = (AtomicType)at.getBaseType();
                }
                return SaxonXQDataFactory.mapSaxonTypeToXQJ(at.getFingerprint());
            }
            if (contentType.isSimpleType()) {
                if (((SimpleType)contentType).isListType()) {
                    int fp = contentType.getFingerprint();
                    if (fp == 557) {
                        return 51;
                    }
                    if (fp == 564) {
                        return 50;
                    }
                    if (fp == 562) {
                        return 49;
                    }
                }
                return 3;
            }
            if (contentType == Untyped.getInstance()) {
                return 1;
            }
            return 2;
        }
        throw new XQException("Wrong item type for getBaseType()");
    }

    @Override
    public int getItemKind() {
        if (this.itemType instanceof AtomicType) {
            return 1;
        }
        if (this.itemType instanceof NodeTest) {
            if (this.itemType instanceof DocumentNodeTest) {
                return 5;
            }
            int x = this.itemType.getPrimitiveType();
            switch (x) {
                case 9: {
                    return 4;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 11;
                }
                case 8: {
                    return 3;
                }
                case 7: {
                    return 10;
                }
                case 0: {
                    return 9;
                }
            }
        }
        return 8;
    }

    @Override
    public int getItemOccurrence() {
        return 2;
    }

    @Override
    public QName getNodeName() throws XQException {
        ItemType type = this.itemType;
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest) {
            if ((((NodeTest)type).getNodeKindMask() & 0x2388) != 0) {
                throw new XQException("Wrong node kind for getNodeName()");
            }
            IntHashSet set = ((NodeTest)type).getRequiredNodeNames();
            if (set != null && set.size() == 1) {
                int fp = set.getFirst(-1);
                NamePool pool = this.config.getNamePool();
                String uri = pool.getURI(fp);
                String local = pool.getLocalName(fp);
                return new QName(uri, local);
            }
            return null;
        }
        throw new XQException("getNodeName() is not defined for this kind of item type");
    }

    @Override
    public String getPIName() throws XQException {
        if (this.itemType instanceof NameTest && this.itemType.getPrimitiveType() == 7) {
            NamePool pool = this.config.getNamePool();
            return pool.getLocalName(((NameTest)this.itemType).getFingerprint());
        }
        if (this.itemType instanceof NodeKindTest && this.itemType.getPrimitiveType() == 7) {
            return null;
        }
        throw new XQException("Item kind is not a processing instruction");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URI getSchemaURI() {
        try {
            if (this.itemType instanceof NodeTest) {
                SchemaType content = ((NodeTest)this.itemType).getContentType();
                if (content == null) {
                    return null;
                }
                String systemId = content.getSystemId();
                if (systemId != null) return new URI(systemId);
                return null;
            }
            if (!(this.itemType instanceof AtomicType)) return null;
            String systemId = ((AtomicType)this.itemType).getSystemId();
            if (systemId == null) {
                return null;
            }
            URI uRI = new URI(systemId);
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.itemType.toString(this.config.getNamePool());
    }

    @Override
    public QName getTypeName() throws XQException {
        ItemType type = this.itemType;
        if (type instanceof AtomicType) {
            int fp = ((AtomicType)type).getFingerprint();
            NamePool pool = this.config.getNamePool();
            String uri = pool.getURI(fp);
            String local = pool.getLocalName(fp);
            return new QName(uri, local);
        }
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest) {
            if ((((NodeTest)type).getNodeKindMask() & 0x2388) != 0) {
                throw new XQException("getTypeName() failed: itemType is not a document, element, or attribute test");
            }
            SchemaType t = ((NodeTest)type).getContentType();
            if (t != null) {
                int fp = ((NodeTest)type).getContentType().getFingerprint();
                NamePool pool = this.config.getNamePool();
                String uri = pool.getURI(fp);
                String local = pool.getLocalName(fp);
                return new QName(uri, local);
            }
        }
        throw new XQException("getTypeName() failed: itemType is not a document, element, or attribute test");
    }

    @Override
    public boolean isAnonymousType() {
        SchemaType t;
        ItemType type = this.itemType;
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest && (t = ((NodeTest)type).getContentType()) != null) {
            return t.isAnonymousType();
        }
        return false;
    }

    @Override
    public boolean isElementNillable() {
        return this.itemType instanceof NodeTest && ((NodeTest)this.itemType).isNillable();
    }

    @Override
    public XQItemType getItemType() {
        return this;
    }

    AtomicType getAtomicType() {
        if (this.itemType instanceof AtomicType) {
            return (AtomicType)this.itemType;
        }
        return null;
    }

    ItemType getSaxonItemType() {
        return this.itemType;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SaxonXQItemType && this.itemType.equals(((SaxonXQItemType)obj).itemType);
    }

    @Override
    public int hashCode() {
        return this.itemType.hashCode();
    }
}

