/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Version;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.Whitespace;

public abstract class AbstractTraceListener
implements TraceListener {
    private int indent = 0;
    private PrintStream out = System.err;
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    @Override
    public void open() {
        this.out.println("<trace saxon-version=\"" + Version.getProductVersion() + "\" " + this.getOpeningAttributes() + '>');
        ++this.indent;
    }

    protected abstract String getOpeningAttributes();

    @Override
    public void close() {
        --this.indent;
        this.out.println("</trace>");
    }

    @Override
    public void enter(InstructionInfo info, XPathContext context) {
        int infotype = info.getConstructType();
        StructuredQName qName = info.getObjectName();
        String tag = this.tag(infotype);
        if (tag == null) {
            return;
        }
        String file = ExpressionLocation.truncateURI(info.getSystemId());
        String msg = String.valueOf(AbstractTraceListener.spaces(this.indent)) + '<' + tag;
        String name = (String)info.getProperty("name");
        if (name != null) {
            msg = String.valueOf(msg) + " name=\"" + this.escape(name) + '\"';
        } else if (qName != null) {
            msg = String.valueOf(msg) + " name=\"" + this.escape(qName.getDisplayName()) + '\"';
        }
        Iterator props = info.getProperties();
        while (props.hasNext()) {
            int rcurly;
            String prop = (String)props.next();
            Object val = info.getProperty(prop);
            if (prop.startsWith("{") && (rcurly = prop.indexOf(125)) > 0) {
                prop = prop.substring(rcurly + 1);
            }
            if (val == null || prop.equals("name") || prop.equals("expression")) continue;
            msg = String.valueOf(msg) + ' ' + prop + "=\"" + this.escape(val.toString()) + '\"';
        }
        msg = String.valueOf(msg) + " line=\"" + info.getLineNumber() + '\"';
        int col = info.getColumnNumber();
        if (col >= 0) {
            msg = String.valueOf(msg) + " column=\"" + info.getColumnNumber() + '\"';
        }
        msg = String.valueOf(msg) + " module=\"" + this.escape(file) + "\">";
        this.out.println(msg);
        ++this.indent;
    }

    public String escape(String in) {
        if (in == null) {
            return "";
        }
        CharSequence collapsed = Whitespace.collapseWhitespace(in);
        StringBuffer sb = new StringBuffer(collapsed.length() + 10);
        int i = 0;
        while (i < collapsed.length()) {
            char c = collapsed.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&#34;");
            } else if (c == '\n') {
                sb.append("&#xA;");
            } else if (c == '\r') {
                sb.append("&#xD;");
            } else if (c == '\t') {
                sb.append("&#x9;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void leave(InstructionInfo info) {
        int infotype = info.getConstructType();
        String tag = this.tag(infotype);
        if (tag == null) {
            return;
        }
        --this.indent;
        this.out.println(String.valueOf(AbstractTraceListener.spaces(this.indent)) + "</" + tag + '>');
    }

    protected abstract String tag(int var1);

    @Override
    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo curr = (NodeInfo)item;
            this.out.println(String.valueOf(AbstractTraceListener.spaces(this.indent)) + "<source node=\"" + Navigator.getPath(curr) + "\" line=\"" + curr.getLineNumber() + "\" file=\"" + ExpressionLocation.truncateURI(curr.getSystemId()) + "\">");
        }
        ++this.indent;
    }

    @Override
    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo) {
            NodeInfo curr = (NodeInfo)item;
            this.out.println(String.valueOf(AbstractTraceListener.spaces(this.indent)) + "</source><!-- " + Navigator.getPath(curr) + " -->");
        }
    }

    private static String spaces(int n) {
        while (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }

    public void setOutputDestination(PrintStream stream) {
        this.out = stream;
    }

    public PrintStream getOutputDestination() {
        return this.out;
    }
}

