/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class WhitespaceTextImpl
extends TinyNodeImpl {
    public WhitespaceTextImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        long value = (long)this.tree.alpha[this.nodeNr] << 32 | (long)this.tree.beta[this.nodeNr] & 0xFFFFFFFFL;
        return new CompressedWhitespace(value);
    }

    public static CharSequence getStringValueCS(TinyTree tree, int nodeNr) {
        long value = (long)tree.alpha[nodeNr] << 32 | (long)tree.beta[nodeNr] & 0xFFFFFFFFL;
        return new CompressedWhitespace(value);
    }

    public static void appendStringValue(TinyTree tree, int nodeNr, FastStringBuffer buffer) {
        long value = (long)tree.alpha[nodeNr] << 32 | (long)tree.beta[nodeNr] & 0xFFFFFFFFL;
        CompressedWhitespace.uncompress(value, buffer);
    }

    @Override
    public Value atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
    }

    public static long getLongValue(TinyTree tree, int nodeNr) {
        return (long)tree.alpha[nodeNr] << 32 | (long)tree.beta[nodeNr] & 0xFFFFFFFFL;
    }

    @Override
    public final int getNodeKind() {
        return 3;
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.characters(this.getStringValueCS(), 0, 0);
    }
}

