/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Message;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public final class XSLMessage
extends StyleElement {
    private Expression terminate = null;
    private Expression select = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String t;
        String terminateAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "terminate") {
                terminateAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "select") {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        if (terminateAtt == null) {
            terminateAtt = "no";
        }
        this.terminate = this.makeAttributeValueTemplate(terminateAtt);
        if (this.terminate instanceof StringLiteral && !(t = ((StringLiteral)this.terminate).getStringValue()).equals("yes") && !t.equals("no")) {
            this.compileError("terminate must be 'yes' or 'no'", "XTSE0020");
        }
    }

    @Override
    public void validate() throws XPathException {
        this.select = this.typeCheck("select", this.select);
        this.terminate = this.typeCheck("terminate", this.terminate);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        Expression b = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (b != null) {
            if (this.select == null) {
                this.select = b;
            } else {
                this.select = Block.makeBlock(this.select, b);
                this.select.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (this.select == null) {
            this.select = new StringLiteral("xsl:message (no content)");
        }
        Message inst = new Message(this.select, this.terminate);
        return inst;
    }
}

